/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.common.infra.maskant.adaptor;

import io.choerodon.core.oauth.CustomUserDetails;
import io.choerodon.core.oauth.DetailsHelper;
import io.hcbm.common.infra.maskant.feign.WorkFlowFeign;
import io.hcbm.common.infra.maskant.valueobject.WorkflowCreateParam;
import io.hcbm.common.util.FeignUtil;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class WorkFlowAdaptor {
    private static final Logger log = LoggerFactory.getLogger(WorkFlowAdaptor.class);
    private WorkFlowFeign workFlowFeign;

    public WorkFlowAdaptor(WorkFlowFeign workFlowFeign) {
        this.workFlowFeign = workFlowFeign;
    }

    public void startWorkFlow(Long tenantId, WorkflowCreateParam createParam) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(createParam);
        Objects.requireNonNull(createParam.getProcessDefinitionKey());
        CustomUserDetails customUserDetails = DetailsHelper.getUserDetails();
        Long organizationId = customUserDetails.getOrganizationId();
        if (StringUtils.isEmpty((Object)createParam.getTenantId()) && organizationId != null) {
            createParam.setTenantId(organizationId.toString());
        }
        ResponseEntity<String> responseEntity = this.workFlowFeign.startWorkFlow(organizationId, createParam);
        log.debug("workflow client responseEntity : {}", responseEntity);
        FeignUtil.checkFailure(responseEntity);
    }
}

