/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.common.service.impl;

import io.choerodon.core.oauth.DetailsHelper;
import io.hcbm.common.infra.maskant.adaptor.AccessRuleAdaptor;
import io.hcbm.common.infra.maskant.valueobject.UnitVO;
import io.hcbm.common.service.AccessScopeService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccessScopeServiceImpl
implements AccessScopeService {
    @Autowired
    private AccessRuleAdaptor accessRuleAdaptor;
    private static final Long EMPTY_UNIT_ID = -1L;

    @Override
    public List<Long> accessUnitId(Long tenantId) {
        Objects.requireNonNull(tenantId);
        List<UnitVO> units = this.accessRuleAdaptor.listUnitByRoleAndUser(tenantId);
        return Optional.ofNullable(units).filter(list -> list.size() > 0).map(list -> list.stream().map(UnitVO::getUnitId).collect(Collectors.toList())).orElseGet(() -> {
            ArrayList<Long> empty = new ArrayList<Long>();
            empty.add(EMPTY_UNIT_ID);
            return empty;
        });
    }

    @Override
    public List<Long> accessUnitId() {
        Long tenantId = DetailsHelper.getUserDetails().getTenantId();
        return this.accessUnitId(tenantId);
    }
}

