/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import io.choerodon.core.exception.CommonException;
import io.hcbm.common.infra.maskant.valueobject.ErrorResponseVO;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class FeignUtil {
    private static final Logger log = LoggerFactory.getLogger(FeignUtil.class);
    private static final String FAILED = "failed";
    private static final Set<Class> BASE_TYPE = new HashSet<Class>();

    public static <T> T checkFailure(ResponseEntity<? extends String> response, Function<String, T> mapper, String msg) {
        String body = FeignUtil.checkFailure(response, msg);
        return mapper.apply(body);
    }

    public static <T> T checkFailure(ResponseEntity<? extends String> response, Function<String, T> mapper) {
        String body = FeignUtil.checkFailure(response, "");
        return mapper.apply(body);
    }

    public static <T> T checkFailure(ResponseEntity<T> response) {
        return FeignUtil.checkFailure(response, "");
    }

    public static <T> T checkFailure(ResponseEntity<T> response, String msg) {
        Object body;
        block12: {
            Objects.requireNonNull(response);
            body = response.getBody();
            HttpStatus status = response.getStatusCode();
            if (Objects.isNull(body) && status.is2xxSuccessful()) {
                return null;
            }
            if (status.is4xxClientError() || status.is5xxServerError() || Objects.isNull(body)) {
                log.error("error feign call, response is : {}", (Object)response.toString());
                throw new CommonException(Optional.ofNullable(msg).filter(StringUtils::isNotEmpty).orElse("error.feign.call"), new Object[0]);
            }
            if (BASE_TYPE.contains(body.getClass())) {
                return (T)body;
            }
            if (body instanceof String) {
                String bodyStr = (String)body;
                if (bodyStr.indexOf(FAILED) > 1) {
                    try {
                        ErrorResponseVO errorResponseVO = (ErrorResponseVO)JSONObject.parseObject((String)bodyStr, ErrorResponseVO.class);
                        if (errorResponseVO.getFailed().booleanValue()) {
                            throw new CommonException(errorResponseVO.getMessage(), new Object[0]);
                        }
                        break block12;
                    }
                    catch (JSONException e) {
                        log.error("feign parse response json error:{}", (Object)response.toString());
                        throw new CommonException("error.feign.translator.response", new Object[0]);
                    }
                }
                return (T)body;
            }
        }
        try {
            Object json = JSONObject.toJSON((Object)body);
            if (json instanceof JSONArray) {
                return (T)body;
            }
            JSONObject jsonObj = (JSONObject)json;
            if (Optional.ofNullable(jsonObj.getBoolean(FAILED)).orElse(Boolean.FALSE).booleanValue()) {
                ErrorResponseVO errorResponseVO = (ErrorResponseVO)JSONObject.toJavaObject((JSON)jsonObj, ErrorResponseVO.class);
                throw new CommonException(errorResponseVO.getMessage(), new Object[0]);
            }
        }
        catch (JSONException e) {
            log.debug("json parse error: {}", body);
        }
        return (T)body;
    }

    static {
        BASE_TYPE.add(Integer.class);
        BASE_TYPE.add(Long.class);
        BASE_TYPE.add(Byte.class);
        BASE_TYPE.add(Boolean.class);
        BASE_TYPE.add(Float.class);
        BASE_TYPE.add(Character.class);
        BASE_TYPE.add(Double.class);
        BASE_TYPE.add(Short.class);
    }
}

