/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.onlyoffice;

import io.choerodon.core.exception.CommonException;
import io.hcbm.common.infra.maskant.adaptor.FileAdaptor;
import io.hcbm.common.util.HttpUtil;
import io.hcbm.onlyoffice.service.OnlyOfficeService;
import io.hcbm.onlyoffice.valueobject.PermissionVO;
import io.hcbm.onlyoffice.valueobject.SaveCallbackParam;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OnlyOfficeClient {
    private static final Logger log = LoggerFactory.getLogger(OnlyOfficeClient.class);
    private FileAdaptor fileAdaptor;
    private OnlyOfficeService onlyOfficeService;
    private static final Pattern fileNamePattern = Pattern.compile("[0-9]/.+(@|%40)(.+)");

    public OnlyOfficeClient(FileAdaptor fileAdaptor, OnlyOfficeService onlyOfficeService) {
        this.fileAdaptor = fileAdaptor;
        this.onlyOfficeService = onlyOfficeService;
    }

    public String generateHtml(Long tenantId, String textFileKey, PermissionVO permission, String callBackEndUrl) {
        String htmlText;
        String fileUrl = this.fileAdaptor.getSignedUrl(tenantId, textFileKey);
        String fileName = this.getFileNameFromKey(textFileKey);
        try {
            htmlText = this.onlyOfficeService.getGenerateHtml(textFileKey, fileUrl, fileName, permission, "onlyOffice", callBackEndUrl);
        }
        catch (Exception e) {
            log.error("onlyOffice generateHtml method occur IOException,message was:" + e.getLocalizedMessage());
            throw new CommonException("error.onlyOffice.generateHtml", new Object[0]);
        }
        return htmlText;
    }

    public void updateTextInfoByOnlyOffice(Long tenantId, SaveCallbackParam saveCallbackParam, String fileKey) {
        log.debug("only office update text saveCallbackParam : {} and fileKey : {}", (Object)saveCallbackParam, (Object)fileKey);
        this.fileAdaptor.updateFile(tenantId, fileKey, HttpUtil.downloadData(saveCallbackParam.getUrl()));
    }

    private String getFileNameFromKey(String filekey) {
        Matcher matcher = fileNamePattern.matcher(filekey);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return filekey;
    }
}

