/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.onlyoffice.service;

import com.alibaba.fastjson.JSON;
import io.choerodon.core.oauth.CustomUserDetails;
import io.choerodon.core.oauth.DetailsHelper;
import io.hcbm.onlyoffice.config.OnlyOfficeConfig;
import io.hcbm.onlyoffice.util.HttpRequestHelper;
import io.hcbm.onlyoffice.valueobject.DocumentVO;
import io.hcbm.onlyoffice.valueobject.EditorVO;
import io.hcbm.onlyoffice.valueobject.GenerateHtmlParam;
import io.hcbm.onlyoffice.valueobject.PermissionVO;
import io.hcbm.onlyoffice.valueobject.RequestParamVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OnlyOfficeService {
    private static final Logger log = LoggerFactory.getLogger(OnlyOfficeService.class);
    @Autowired
    private OnlyOfficeConfig config;

    public String getGenerateHtml(String textFileKey, String fileUrl, String fileName, PermissionVO permission, String extraParamType, String callBackEndUrl) throws Exception {
        return new HttpRequestHelper().sendRequestToDocumentServer(this.generateRequestParam(textFileKey, fileUrl, fileName, permission, extraParamType, callBackEndUrl)).toString();
    }

    private RequestParamVO generateRequestParam(String textFileKey, String fileUrl, String fileName, PermissionVO permission, String extraParamType, String callBackEndUrl) {
        RequestParamVO paramVO = new RequestParamVO();
        DocumentVO document = new DocumentVO();
        document.setTitle(fileName);
        document.setFileId(textFileKey);
        document.setUrl(fileUrl);
        EditorVO editor = new EditorVO();
        editor.setCallbackUrl(this.config.getCallBackUrl() + callBackEndUrl);
        CustomUserDetails userDetails = DetailsHelper.getUserDetails();
        editor.setUserId(userDetails.getUserId().toString());
        editor.setUserName(userDetails.getRealName());
        GenerateHtmlParam generateHtmlParam = new GenerateHtmlParam();
        generateHtmlParam.setDocument(document);
        generateHtmlParam.setEditor(editor);
        generateHtmlParam.setExtra(extraParamType);
        generateHtmlParam.setPermissions(permission);
        paramVO.setAccessToken(this.config.getAccessToken());
        paramVO.setEviUrl(this.config.getGenerateHtmlUrl());
        paramVO.setBodyJson(JSON.toJSONString((Object)generateHtmlParam));
        log.debug("generateRequestParam param : {}", (Object)paramVO);
        return paramVO;
    }
}

