/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.onlyoffice.util;

import io.choerodon.core.exception.CommonException;
import io.hcbm.onlyoffice.valueobject.RequestParamVO;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMethod;

public class HttpRequestHelper {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestHelper.class);

    private void initPostHeaders(HttpURLConnection httpURLConnection, String documentServerToken) {
        try {
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestMethod(RequestMethod.POST.name());
            httpURLConnection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            httpURLConnection.setRequestProperty("token", documentServerToken);
        }
        catch (IOException e) {
            log.error("\u8bbe\u7f6e\u8bf7\u6c42\u62a5\u5934 HTTP Headers\u5f02\u5e38\uff1a" + e.getMessage());
            throw new CommonException("initPostHeaders:" + e.getMessage(), new Object[0]);
        }
    }

    public StringBuilder sendRequestToDocumentServer(RequestParamVO parameterVO) throws IOException {
        BufferedReader responseReader;
        StringBuilder stringBuilder;
        URL url = new URL(parameterVO.getEviUrl());
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        this.initPostHeaders(httpURLConnection, parameterVO.getAccessToken());
        httpURLConnection.connect();
        DataOutputStream dos = new DataOutputStream(httpURLConnection.getOutputStream());
        dos.write(parameterVO.getBodyJson().getBytes(StandardCharsets.UTF_8));
        dos.flush();
        dos.close();
        int resultCode = httpURLConnection.getResponseCode();
        if (200 == resultCode) {
            String readLine;
            stringBuilder = new StringBuilder();
            responseReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), StandardCharsets.UTF_8));
            while ((readLine = responseReader.readLine()) != null) {
                stringBuilder.append(readLine);
            }
        } else {
            log.error("current onlyOffice resultCode was:{}" + resultCode);
            throw new CommonException("error.contract.text.sendRequestToOnlyOffice", new Object[0]);
        }
        responseReader.close();
        return stringBuilder;
    }
}

