/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.common.mappers.helper;

import io.choerodon.core.exception.CommonException;
import io.choerodon.mybatis.MapperException;
import io.choerodon.mybatis.annotation.ModifyAudit;
import io.choerodon.mybatis.annotation.VersionAudit;
import io.choerodon.mybatis.domain.EntityColumn;
import io.choerodon.mybatis.helper.EntityHelper;
import io.choerodon.mybatis.helper.SqlHelper;
import io.hcbm.common.mappers.helper.OneEntityHelper;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.hzero.mybatis.helper.TenantLimitedHelper;

public class OneSqlHelper {
    public static final String AND = " AND ";
    public static final String LEFT_WHERE = "<where>";
    public static final String RIGHT_WHERE = "</where>";

    public static String selectPKColumns(Class<?> entityClass) {
        return "SELECT " + OneSqlHelper.getPKColumns(entityClass) + " ";
    }

    public static String getPKColumns(Class<?> entityClass) {
        Set columnList = EntityHelper.getPKColumns(entityClass);
        StringBuilder sql = new StringBuilder();
        for (EntityColumn entityColumn : columnList) {
            if (EntityHelper.getTableByEntity(entityClass).isMultiLanguage() && (entityColumn.isMultiLanguage() || entityColumn.isId())) {
                sql.append(entityColumn.isMultiLanguage() ? "t." : "b.");
            }
            sql.append(entityColumn.getColumn()).append(",");
        }
        return sql.substring(0, sql.length() - 1);
    }

    public static String whereUUIDColumnsTl(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append(LEFT_WHERE);
        Set<EntityColumn> uuidColumn = OneEntityHelper.getUUIDColumn(entityClass);
        if (CollectionUtils.isEmpty(uuidColumn)) {
            throw new CommonException("not found uuid fields or columns", new Object[0]);
        }
        for (EntityColumn column : uuidColumn) {
            sql.append(AND).append(column.getColumnEqualsHolderTl(null));
        }
        if (TenantLimitedHelper.isOpen()) {
            sql.append(SqlHelper.getTenantLimit(entityClass));
        }
        sql.append(RIGHT_WHERE);
        return sql.toString();
    }

    public static String whereUUIDAndVersion(Class<?> entityClass) {
        boolean versionAudit = entityClass.isAnnotationPresent(VersionAudit.class);
        StringBuilder sql = new StringBuilder();
        sql.append(LEFT_WHERE);
        Set<EntityColumn> columnList = OneEntityHelper.getUUIDColumn(entityClass);
        for (EntityColumn column : columnList) {
            sql.append(AND).append(column.getColumnEqualsHolder(null));
        }
        if (versionAudit) {
            sql.append(" AND OBJECT_VERSION_NUMBER = #{objectVersionNumber}");
        }
        sql.append(RIGHT_WHERE);
        return sql.toString();
    }

    public static String whereUUIDColumns(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append(LEFT_WHERE);
        Set<EntityColumn> columnList = OneEntityHelper.getUUIDColumn(entityClass);
        for (EntityColumn column : columnList) {
            sql.append(AND + column.getColumnEqualsHolder(null));
        }
        sql.append(RIGHT_WHERE);
        return sql.toString();
    }

    public static String updateSetColumnsAndVersion(Class<?> entityClass, String entityName, boolean notNull, boolean notEmpty) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("<set>");
        Set columnSet = EntityHelper.getColumns(entityClass);
        boolean modifyAudit = entityClass.isAnnotationPresent(ModifyAudit.class);
        boolean versionAudit = entityClass.isAnnotationPresent(VersionAudit.class);
        for (EntityColumn column : columnSet) {
            String columnName;
            if (OneSqlHelper.fillSelfMaintainFields(sql, modifyAudit, versionAudit, column, columnName = column.getProperty()) || column.isId() || !column.isUpdatable() || column.isUuid()) continue;
            if (notNull) {
                sql.append(SqlHelper.getIfNotNull((String)entityName, (EntityColumn)column, (String)(column.getColumnEqualsHolder(entityName) + ","), (boolean)notEmpty));
                continue;
            }
            sql.append(column.getColumnEqualsHolder(entityName) + ",");
        }
        sql.append("</set>");
        return sql.toString();
    }

    private static boolean fillSelfMaintainFields(StringBuilder sql, boolean modifyAudit, boolean versionAudit, EntityColumn column, String columnName) {
        if (modifyAudit && SqlHelper.MODIFY_AUDIT_FIELDS.contains(column.getProperty())) {
            if ("lastUpdateDate".equals(columnName)) {
                sql.append("LAST_UPDATE_DATE = #{audit.now},");
            } else if ("lastUpdatedBy".equals(columnName)) {
                sql.append("LAST_UPDATED_BY = #{audit.user},");
            }
            return true;
        }
        if (versionAudit && SqlHelper.VERSION_AUDIT_FIELDS.contains(column.getProperty())) {
            if (!"objectVersionNumber".equals(columnName)) {
                throw new MapperException("\u672a\u77e5\u7684Version\u5217" + columnName);
            }
            sql.append("OBJECT_VERSION_NUMBER = OBJECT_VERSION_NUMBER+1,");
            return true;
        }
        return false;
    }
}

