/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.sun.corba.se.impl.encoding.OSFCodeSetRegistry;
import io.choerodon.core.exception.CommonException;
import io.hcbm.common.exception.HttpResponseException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static final int DEFAULT_CONNECTION_TIME_OUT = 10000;
    private static final int DEFAULT_READ_TIME_OUT = 10000;
    private static final String USER_NAME_FIELD = "username";
    private static final String PASSWORD_FIELD = "password";
    private static final String GRANT_TYPE_FIELD = "grant_type";
    private static final String GRANT_TYPE_VALUE = "password";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String AUTHORIZATION_BASIC = "Basic";

    public static JSONObject doOauth2(String url, String userName, String password, String token) throws HttpResponseException {
        Objects.requireNonNull(userName, "\u767b\u5f55\u8d26\u53f7");
        Objects.requireNonNull(password, "\u767b\u5f55\u5bc6\u7801");
        HashMap<String, String> bodyParam = new HashMap<String, String>();
        bodyParam.put(USER_NAME_FIELD, userName);
        bodyParam.put("password", password);
        bodyParam.put(GRANT_TYPE_FIELD, "password");
        if (StringUtils.isBlank((CharSequence)token)) {
            return HttpUtil.sentPostWithForm(url, bodyParam, null);
        }
        HashMap<String, String> headerParam = new HashMap<String, String>();
        headerParam.put(AUTHORIZATION_HEADER, "Basic " + token);
        return HttpUtil.sentPostWithForm(url, bodyParam, headerParam);
    }

    public static JSONObject sentPostWithJsonByAuthorization(String url, Map<String, ?> body, String token) throws HttpResponseException {
        Objects.requireNonNull(token, "Authorization token");
        HashMap<String, String> authHeader = new HashMap<String, String>();
        authHeader.put(AUTHORIZATION_HEADER, token);
        return HttpUtil.sentPostWithJson(url, body, authHeader);
    }

    public static JSONObject sentPostWithJson(String url, Map<String, ?> bodyParam, Map<String, String> headerParam) throws HttpResponseException {
        return HttpUtil.sentPost(url, bodyParam, MediaType.APPLICATION_JSON_UTF8, headerParam);
    }

    public static JSONObject sentPostWithForm(String url, Map<String, ?> bodyParam, Map<String, String> headerParam) throws HttpResponseException {
        return HttpUtil.sentPost(url, bodyParam, MediaType.APPLICATION_FORM_URLENCODED, headerParam);
    }

    public static JSONObject sentPost(String url, Map<String, ?> bodyParam, MediaType contentType, Map<String, String> headerParam) throws HttpResponseException {
        String result = "";
        BufferedReader in = null;
        Integer status = null;
        try {
            URL realUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)realUrl.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            if (Objects.nonNull(headerParam) && !headerParam.isEmpty()) {
                headerParam.forEach(connection::setRequestProperty);
            }
            connection.setDoOutput(true);
            connection.setDoInput(true);
            HttpUtil.processPostContentType(contentType, bodyParam, connection);
            status = connection.getResponseCode();
            try {
                String line;
                in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
                while (StringUtils.isNotEmpty((CharSequence)(line = in.readLine()))) {
                    result = result + line;
                }
            }
            catch (IOException e) {
                String line;
                in = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));
                while (StringUtils.isNotEmpty((CharSequence)(line = in.readLine()))) {
                    result = result + line;
                }
            }
        }
        catch (Exception e) {
            throw new HttpResponseException((Integer)Optional.ofNullable(status).orElse(HttpStatus.INTERNAL_SERVER_ERROR.value()), result, "\u8bf7\u6c42\u5931\u8d25");
        }
        finally {
            try {
                if (Objects.nonNull(in)) {
                    in.close();
                }
            }
            catch (IOException e) {
                log.error("http \u8bf7\u6c42\u5931\u8d25\uff0c\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e);
            }
        }
        if (Objects.isNull(status)) {
            status = HttpStatus.REQUEST_TIMEOUT.value();
        }
        if (status >= 200 && status < 300) {
            return (JSONObject)JSONObject.parse((String)result);
        }
        throw new HttpResponseException(status, result, "POST\u8bf7\u6c42\u5931\u8d25");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processPostContentType(MediaType contentType, Map<String, ?> bodyParam, HttpURLConnection connection) throws IOException {
        Supplier<String> buildParam = null;
        MediaType mediaType = contentType = Objects.isNull(contentType) ? MediaType.APPLICATION_FORM_URLENCODED : contentType;
        if (MediaType.APPLICATION_FORM_URLENCODED.getSubtype().equalsIgnoreCase(contentType.getSubtype())) {
            buildParam = () -> HttpUtil.buildForm(bodyParam);
        } else if (MediaType.APPLICATION_JSON_UTF8.getSubtype().equalsIgnoreCase(contentType.getSubtype())) {
            buildParam = () -> HttpUtil.buildJSON(bodyParam);
        } else {
            contentType = MediaType.APPLICATION_FORM_URLENCODED;
            buildParam = () -> HttpUtil.buildForm(bodyParam);
        }
        PrintWriter out = null;
        connection.setRequestProperty("Content-type", contentType.toString());
        try {
            out = new PrintWriter(new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8));
            out.print(buildParam.get());
            out.flush();
        }
        finally {
            if (Objects.nonNull(out)) {
                out.close();
            }
        }
    }

    private static String buildForm(Map<String, ?> param) {
        if (Objects.isNull(param) || param.isEmpty()) {
            return "";
        }
        return param.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue().toString()).collect(Collectors.joining("&"));
    }

    private static String buildJSON(Map<String, ?> param) {
        if (Objects.isNull(param) || param.isEmpty()) {
            return "";
        }
        return JSON.toJSONString(param);
    }

    public static JSONObject sendGet(String url, Map<String, Object> param, Map<String, String> headerParam) throws HttpResponseException {
        BufferedReader in = null;
        String result = "";
        Integer status = null;
        try {
            String line;
            URL realUrl = new URL(HttpUtil.getUrl(url, param));
            HttpURLConnection connection = (HttpURLConnection)realUrl.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            if (Objects.nonNull(headerParam) && !headerParam.isEmpty()) {
                for (String key2 : headerParam.keySet()) {
                    connection.setRequestProperty(key2, headerParam.get(key2));
                }
            }
            connection.connect();
            status = connection.getResponseCode();
            Map<String, List<String>> map = connection.getHeaderFields();
            map.forEach((key, values) -> log.info(key + ":" + values.toString()));
            try {
                in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
                while ((line = in.readLine()) != null) {
                    result = result + line;
                }
            }
            catch (IOException e) {
                in = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));
                while ((line = in.readLine()) != null) {
                    result = result + line;
                }
            }
        }
        catch (Exception var18) {
            throw new HttpResponseException((Integer)Optional.ofNullable(status).orElse(HttpStatus.INTERNAL_SERVER_ERROR.value()), result, "\u8bf7\u6c42\u5931\u8d25");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                log.error("http \u8bf7\u6c42\u5931\u8d25\uff0c\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e);
            }
        }
        if (Objects.nonNull(status) && status >= 200 && status < 300) {
            return (JSONObject)JSONObject.parse((String)result);
        }
        throw new HttpResponseException(Optional.ofNullable(status).orElse(HttpStatus.REQUEST_TIMEOUT.value()), result, "\u8bf7\u6c42\u5931\u8d25");
    }

    private static String getUrl(String url, Map<String, Object> param) {
        StringBuilder sb = new StringBuilder();
        String equals = "=";
        sb.append(url);
        if (Objects.nonNull(param) && !param.isEmpty()) {
            sb.append("?");
            Object tempValue = null;
            int count = 0;
            for (String key : param.keySet()) {
                tempValue = param.get(key);
                if (tempValue instanceof String && StringUtils.isNotBlank((CharSequence)tempValue.toString())) {
                    sb.append(count == 0 ? "" : "&").append(key).append(equals).append(HttpUtil.encodeUrl(tempValue.toString()));
                    ++count;
                }
                if (!(tempValue instanceof List)) continue;
                List conditions = (List)tempValue;
                for (Object value : conditions) {
                    if (!(value instanceof String) || !StringUtils.isNotBlank((CharSequence)value.toString())) continue;
                    sb.append(count == 0 ? "" : "&").append(key).append(equals).append(HttpUtil.encodeUrl(value.toString()));
                    ++count;
                }
            }
        }
        return sb.toString();
    }

    private static String encodeUrl(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        try {
            return URLEncoder.encode(url, OSFCodeSetRegistry.UTF_8.getName());
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    public static InputStream download(String url) {
        Objects.requireNonNull(url, "url must be not null");
        URL downUrl = null;
        try {
            downUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)downUrl.openConnection();
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            return conn.getInputStream();
        }
        catch (MalformedURLException e) {
            log.info("url:{}", (Object)url);
            e.printStackTrace();
            throw new CommonException("error.url.value", new Object[]{url});
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommonException("error.download.file", new Object[]{url});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] downloadData(String url) {
        Objects.requireNonNull(url, "url must be not null");
        Object downUrl = null;
        InputStream inputStream = HttpUtil.download(url);
        try {
            byte[] byArray = HttpUtil.readInputStream(inputStream);
            return byArray;
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return null;
    }

    public static byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = inputStream.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        IOUtils.closeQuietly((OutputStream)bos);
        return bos.toByteArray();
    }
}

