/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.common.uuid;

import io.choerodon.mybatis.domain.AuditDomain;
import io.hcbm.common.util.UUIDUtil;
import io.hcbm.common.uuid.OneDomain;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import org.apache.commons.lang3.StringUtils;

public class OneAuditDomain
extends AuditDomain {
    @GeneratedValue(generator="UUID")
    @ApiModelProperty(hidden=true)
    @Column(updatable=false)
    private String uuid;

    public String getUuid() {
        return this.uuid;
    }

    public <T extends OneAuditDomain> void uuidVisit(T domain) {
        if (Objects.isNull(this.uuid)) {
            this.uuid = domain.getUuid();
            return;
        }
        throw new UnsupportedOperationException();
    }

    public <T extends OneDomain> void uuidVisit(T domain) {
        if (Objects.isNull(this.uuid)) {
            this.uuid = domain.getUuid();
            return;
        }
        throw new UnsupportedOperationException();
    }

    protected void updateUuid(String uuid) {
        if (StringUtils.isEmpty((CharSequence)uuid) || StringUtils.equals((CharSequence)uuid, (CharSequence)this.uuid)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.uuid)) {
            throw new UnsupportedOperationException("UUID cannot be overwritten");
        }
        this.uuid = UUIDUtil.requiredUUID(uuid);
    }

    public void clearUuid() {
        this.uuid = null;
    }
}

