/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.onlyoffice.config;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class OneOfficeConfigCondition
implements Condition {
    private static final Logger log = LoggerFactory.getLogger(OneOfficeConfigCondition.class);

    public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
        Environment environment = conditionContext.getEnvironment();
        String token = environment.getProperty("onlyoffice.access-token");
        String host = environment.getProperty("onlyoffice.host");
        String callBackUrl = environment.getProperty("onlyoffice.call-back-url");
        log.info("one office config: token: {}, host: {}, callBackUrl: {}", new Object[]{token, host, callBackUrl});
        return StringUtils.isNotEmpty((CharSequence)token) && StringUtils.isNotEmpty((CharSequence)host) && StringUtils.isNotEmpty((CharSequence)callBackUrl);
    }
}

