/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.onlyoffice.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.choerodon.core.exception.CommonException;
import io.choerodon.core.oauth.CustomUserDetails;
import io.choerodon.core.oauth.DetailsHelper;
import io.hcbm.common.exception.HttpResponseException;
import io.hcbm.common.util.HttpUtil;
import io.hcbm.onlyoffice.config.OneOfficeConfig;
import io.hcbm.onlyoffice.util.HttpRequestHelper;
import io.hcbm.onlyoffice.valueobject.DocumentVO;
import io.hcbm.onlyoffice.valueobject.EditorVO;
import io.hcbm.onlyoffice.valueobject.GenerateHtmlParam;
import io.hcbm.onlyoffice.valueobject.PermissionVO;
import io.hcbm.onlyoffice.valueobject.RequestParamVO;
import io.hcbm.onlyoffice.valueobject.SaveParam;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class OneOfficeService {
    private static final Logger log = LoggerFactory.getLogger(OneOfficeService.class);
    private final OneOfficeConfig config;

    public OneOfficeService(OneOfficeConfig config) {
        this.config = config;
    }

    public String getGenerateHtml(String textFileKey, String fileUrl, String fileName, PermissionVO permission, String extraParamType, String callBackEndUrl) throws Exception {
        return new HttpRequestHelper().sendRequestToDocumentServer(this.generateRequestParam(textFileKey, fileUrl, fileName, permission, extraParamType, callBackEndUrl)).toString();
    }

    public void saveDoc(SaveParam saveParam) {
        Objects.requireNonNull(saveParam);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("token", this.config.getAccessToken());
        try {
            JSONObject response = HttpUtil.sentPostWithJson(this.config.getHost() + this.config.getSaveDocPath(), saveParam.toMap(), token);
            log.info("\u624b\u52a8\u4fdd\u5b58\u6587\u4ef6\u6210\u529f, \u6587\u4ef6id\uff1a{}, \u76f8\u5e94\u7ed3\u679c\uff1a{}", (Object)saveParam.getFileId(), (Object)response.toJSONString());
        }
        catch (HttpResponseException e) {
            if (e.getResponseCode() == HttpStatus.BAD_REQUEST.value()) {
                log.warn("\u8bf7\u6c42\u4fdd\u5b58\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a " + saveParam.getFileId(), (Throwable)e);
            }
            log.error("\u624b\u52a8\u4fdd\u5b58\u6587\u6863\u53d1\u751f\u9519\u8bef", (Throwable)e);
            throw new CommonException(e.getMessage(), new Object[0]);
        }
    }

    private RequestParamVO generateRequestParam(String textFileKey, String fileUrl, String fileName, PermissionVO permission, String extraParamType, String callBackEndUrl) {
        RequestParamVO paramVO = new RequestParamVO();
        DocumentVO document = new DocumentVO();
        document.setTitle(fileName);
        document.setFileId(textFileKey);
        document.setUrl(fileUrl);
        EditorVO editor = new EditorVO();
        editor.setCallbackUrl(this.buildUrl(this.config.getCallBackUrl(), callBackEndUrl));
        CustomUserDetails userDetails = DetailsHelper.getUserDetails();
        editor.setUserId(userDetails.getUserId().toString());
        editor.setUserName(userDetails.getRealName());
        GenerateHtmlParam generateHtmlParam = new GenerateHtmlParam();
        generateHtmlParam.setDocument(document);
        generateHtmlParam.setEditor(editor);
        generateHtmlParam.setExtra(extraParamType);
        generateHtmlParam.setPermissions(permission);
        paramVO.setAccessToken(this.config.getAccessToken());
        paramVO.setEviUrl(this.config.getHost() + this.config.getGenerateHtmlPath());
        paramVO.setBodyJson(JSON.toJSONString((Object)generateHtmlParam));
        log.debug("generateRequestParam param : {}", (Object)paramVO);
        return paramVO;
    }

    private String buildUrl(String host, String path) {
        Objects.requireNonNull(host);
        Objects.requireNonNull(path);
        String fix = "/";
        if (host.endsWith("/") && path.startsWith("/")) {
            return host + path.substring(1);
        }
        if (host.endsWith("/") && !path.startsWith("/")) {
            return host + path;
        }
        if (!host.endsWith("/") && path.startsWith("/")) {
            return host + path;
        }
        return host + "/" + path;
    }
}

