/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.common.handler;

import io.choerodon.core.exception.CommonException;
import io.choerodon.core.exception.ExceptionResponse;
import io.choerodon.core.exception.NotFoundException;
import io.choerodon.core.oauth.CustomUserDetails;
import io.choerodon.core.oauth.DetailsHelper;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.StringUtils;
import org.hzero.core.exception.BaseExceptionHandler;
import org.hzero.core.message.Message;
import org.hzero.core.message.MessageAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@ControllerAdvice
public class HcbmControllerExceptionHandler
extends BaseExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(HcbmControllerExceptionHandler.class);
    private static final Map<Locale, String> MAP = new HashMap<Locale, String>();
    private static final Map<Locale, String> EXCEPTION_MAP = new HashMap<Locale, String>();
    private static final String LOCALE_EN_US = "en_US";
    @Value(value="${spring.application.name:current-server}")
    private String serverName;

    @ExceptionHandler(value={CommonException.class})
    public ResponseEntity<ExceptionResponse> process(CommonException exception) {
        log.info(this.logPrefix("{}"), (Throwable)exception);
        ExceptionResponse es = new ExceptionResponse(this.getErrorMessage(exception.getCode(), exception.getParameters()));
        return new ResponseEntity((Object)es, HttpStatus.OK);
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public ResponseEntity<ExceptionResponse> process(DuplicateKeyException exception) {
        log.info(this.logPrefix("{}"), (Throwable)exception);
        String message = null;
        try {
            message = MAP.get(this.locale());
        }
        catch (Exception e) {
            log.trace(this.logPrefix("get massage exception {}"), (Throwable)exception);
        }
        ExceptionResponse er = new ExceptionResponse(this.generateErrorMessage(message));
        return ResponseEntity.badRequest().body((Object)er);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ResponseEntity<ExceptionResponse> process(MissingServletRequestParameterException exception) {
        log.info(this.logPrefix("{}"), (Throwable)exception);
        Message msg = this.generateErrorMessage(exception.getLocalizedMessage());
        return ResponseEntity.badRequest().body((Object)new ExceptionResponse(msg));
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public ResponseEntity<ExceptionResponse> process(MethodArgumentTypeMismatchException exception) {
        log.info(this.logPrefix("{}"), (Throwable)exception);
        String message = null;
        try {
            message = exception.getLocalizedMessage();
        }
        catch (Exception e) {
            log.trace(this.logPrefix("get massage exception {}"), (Throwable)exception);
        }
        Message msgObj = this.generateErrorMessage(message != null ? message : "MethodArgumentTypeMismatchException");
        return ResponseEntity.badRequest().body((Object)new ExceptionResponse(msgObj));
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<ExceptionResponse> process(ConstraintViolationException exception) {
        log.info(this.logPrefix("{}"), (Throwable)exception);
        String message = exception.getConstraintViolations().stream().map(ConstraintViolation::getMessage).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).map(this::getErrorMessage).map(Message::desc).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).collect(Collectors.joining(";"));
        return ResponseEntity.badRequest().body((Object)new ExceptionResponse(this.generateErrorMessage(message)));
    }

    @ExceptionHandler(value={NotFoundException.class})
    public ResponseEntity<ExceptionResponse> process(NotFoundException exception) {
        EXCEPTION_MAP.put(Locale.SIMPLIFIED_CHINESE, "\u8d44\u6e90\u4e0d\u5b58\u5728");
        EXCEPTION_MAP.put(Locale.US, "Resources do not exist");
        Message msgObj = this.getErrorMessage(exception.getMessage());
        if (msgObj.code().equals(exception.getMessage())) {
            msgObj = this.generateErrorMessage(EXCEPTION_MAP.get(Locale.US));
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)new ExceptionResponse(msgObj));
    }

    @ExceptionHandler(value={BadSqlGrammarException.class})
    public ResponseEntity<ExceptionResponse> process(BadSqlGrammarException exception) {
        log.info(this.logPrefix("{}"), (Throwable)exception);
        EXCEPTION_MAP.put(Locale.SIMPLIFIED_CHINESE, "\u6570\u636e\u5e93sql\u8bed\u53e5\u9519\u8bef,\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458");
        EXCEPTION_MAP.put(Locale.US, "There is something wrong with sql, please connect with the developer");
        String message = null;
        try {
            message = EXCEPTION_MAP.get(this.locale());
        }
        catch (Exception e) {
            log.trace(this.logPrefix("get massage exception {}"), (Throwable)exception);
        }
        Message msgObj = this.generateErrorMessage(StringUtils.isNotEmpty((CharSequence)message) ? message : EXCEPTION_MAP.get(Locale.US));
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new ExceptionResponse(msgObj));
    }

    private Locale locale() {
        CustomUserDetails details = DetailsHelper.getUserDetails();
        Locale locale = Locale.SIMPLIFIED_CHINESE;
        if (details != null && LOCALE_EN_US.equals(details.getLanguage())) {
            locale = Locale.US;
        }
        return locale;
    }

    private String logPrefix(String content) {
        String prefix = this.serverName + "exception process ";
        if (StringUtils.isEmpty((CharSequence)content)) {
            return prefix;
        }
        return prefix + content;
    }

    private Message getErrorMessage(String code, Object[] args) {
        Message message = MessageAccessor.getMessage((String)code, (Object[])args, (String)code, (Locale)this.locale());
        message.setType(Message.Type.ERROR.code());
        return message;
    }

    private Message getErrorMessage(String code) {
        Message message = MessageAccessor.getMessage((String)code, (String)code, (Locale)this.locale());
        message.setType(Message.Type.ERROR.code());
        return message;
    }

    private Message generateErrorMessage(String errorDesc) {
        return new Message(null, errorDesc, Message.Type.ERROR);
    }

    static {
        MAP.put(Locale.SIMPLIFIED_CHINESE, "\u5b9e\u4f53\u5b57\u6bb5\u91cd\u590d");
        MAP.put(Locale.US, "Entity field is repeated");
    }
}

