/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.common.helper;

import io.choerodon.core.convertor.ConvertHelper;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;

public class ConvertAroundHelper {
    public static <T, R> AroundList<T, R> aroundList(List<T> listSource, Class<R> clazzIn, Class<T> clazzOut) {
        return new AroundList(listSource, clazzIn, clazzOut);
    }

    public static <T, R> Around<T, R> around(T source, Class<R> clazzIn, Class<T> clazzOut) {
        return new Around(source, clazzIn, clazzOut);
    }

    public static class Around<T, R> {
        private T source;
        private Class<R> clazzIn;
        private Class<T> clazzOut;

        private Around(T source, Class<R> clazzIn, Class<T> clazzOut) {
            this.source = source;
            this.clazzIn = clazzIn;
            this.clazzOut = clazzOut;
        }

        public T convert(Function<R, R> mapper) {
            Object param = ConvertHelper.convert(this.source, this.clazzIn);
            return (T)ConvertHelper.convert(mapper.apply(param), this.clazzOut);
        }

        public List<T> convertList(Function<R, List<R>> mapper) {
            Object param = ConvertHelper.convert(this.source, this.clazzIn);
            return ConvertHelper.convertList(mapper.apply(param), this.clazzOut);
        }
    }

    public static class AroundList<T, R> {
        private List<T> listSource;
        private Class<R> clazzIn;
        private Class<T> clazzOut;

        private AroundList(List<T> listSource, Class<R> clazzIn, Class<T> clazzOut) {
            this.listSource = listSource;
            this.clazzIn = clazzIn;
            this.clazzOut = clazzOut;
        }

        public List<T> convert(Function<List<R>, List<R>> mapper) {
            if (CollectionUtils.isEmpty(this.listSource)) {
                return Collections.emptyList();
            }
            Objects.requireNonNull(this.clazzIn);
            Objects.requireNonNull(this.clazzOut);
            List param = ConvertHelper.convertList(this.listSource, this.clazzIn);
            return ConvertHelper.convertList(mapper.apply(param), this.clazzOut);
        }
    }
}

