/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.common.infra.maskant.adaptor;

import io.choerodon.core.exception.CommonException;
import io.hcbm.common.infra.maskant.feign.FileFeign;
import io.hcbm.common.infra.maskant.valueobject.FileSimpleVO;
import io.hcbm.common.util.FeignUtil;
import io.hcbm.common.util.HttpUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.IOUtils;
import org.hzero.boot.file.FileClient;
import org.hzero.boot.file.dto.FileSimpleDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Component
public class FileAdaptor {
    private static final Logger log = LoggerFactory.getLogger(FileAdaptor.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(FileAdaptor.class);
    private static final int DEFAULT_DOC_TYPE = 1;
    private static final String DEFAULT_FORM_FILE_FIELD_NAME = "file";
    private FileClient fileClient;
    private FileFeign fileFeign;

    public FileAdaptor(FileClient fileClient, FileFeign fileFeign) {
        this.fileClient = fileClient;
        this.fileFeign = fileFeign;
    }

    public FileSimpleVO uploadFileByMultipart(Long tenantId, String bucketName, String fileName, Integer type, byte[] fileData) {
        Objects.requireNonNull(tenantId);
        DiskFileItem fileItem = (DiskFileItem)new DiskFileItemFactory().createItem(DEFAULT_FORM_FILE_FIELD_NAME, "multipart/form-data", true, fileName);
        try (ByteArrayInputStream input = new ByteArrayInputStream(fileData);
             OutputStream os = fileItem.getOutputStream();){
            IOUtils.copy((InputStream)input, (OutputStream)os);
        }
        catch (Exception e) {
            log.error("Invalid file: " + e, (Throwable)e);
            throw new CommonException("error.upload.file", new Object[0]);
        }
        CommonsMultipartFile multi = new CommonsMultipartFile((FileItem)fileItem);
        FileSimpleDTO fileInfo = this.fileClient.uploadFileWithMD5(tenantId, bucketName, null, fileName, type.intValue(), (MultipartFile)multi);
        return new FileSimpleVO(fileInfo);
    }

    public FileSimpleVO uploadFileByMultipart(Long tenantId, String bucketName, String fileName, byte[] fileData) {
        return this.uploadFileByMultipart(tenantId, bucketName, fileName, (Integer)1, fileData);
    }

    public FileSimpleVO uploadFileByMultipart(Long tenantId, String bucketName, String fileName, Integer type, InputStream fileInput) {
        Objects.requireNonNull(tenantId);
        DiskFileItem fileItem = (DiskFileItem)new DiskFileItemFactory().createItem(DEFAULT_FORM_FILE_FIELD_NAME, "multipart/form-data", true, fileName);
        try (OutputStream os = fileItem.getOutputStream();){
            IOUtils.copy((InputStream)fileInput, (OutputStream)os);
        }
        catch (Exception e) {
            log.error("Invalid file: " + e, (Throwable)e);
            throw new CommonException("error.upload.file", new Object[0]);
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileInput);
        }
        CommonsMultipartFile multi = new CommonsMultipartFile((FileItem)fileItem);
        FileSimpleDTO fileInfo = this.fileClient.uploadFileWithMD5(tenantId, bucketName, null, fileName, type.intValue(), (MultipartFile)multi);
        return new FileSimpleVO(fileInfo);
    }

    public FileSimpleVO uploadFileByMultipart(Long tenantId, String bucketName, String fileName, InputStream fileInput) {
        return this.uploadFileByMultipart(tenantId, bucketName, fileName, (Integer)1, fileInput);
    }

    public FileSimpleVO uploadFileByMultipart(Long tenantId, String bucketName, MultipartFile file) {
        Objects.requireNonNull(tenantId);
        try {
            return this.uploadFileByMultipart(tenantId, bucketName, file.getOriginalFilename(), file.getInputStream());
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            throw new CommonException("error.upload.file", new Object[0]);
        }
    }

    public byte[] getFileByte(Long tenantId, String url) {
        String[] fileUrlAttr = url.split("(://|/|%40|@)");
        if (fileUrlAttr.length == 6) {
            return this.getFileByte(tenantId, fileUrlAttr[2], url);
        }
        return this.getFileByte(tenantId, fileUrlAttr[3], url);
    }

    public byte[] getFileByte(Long tenantId, String bucketName, String url) {
        try {
            return HttpUtil.readInputStream(this.fileClient.downloadFile(tenantId, bucketName, url));
        }
        catch (IOException e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u6570\u636e\u9519\u8bef", (Throwable)e);
            throw new CommonException("error.download.file", new Object[]{"${hzero.service.file.name:hzero-file}"});
        }
    }

    public FileSimpleVO updateFile(Long tenantId, String key, String fileName, byte[] fileData) {
        Objects.requireNonNull(tenantId);
        DiskFileItem fileItem = (DiskFileItem)new DiskFileItemFactory().createItem(DEFAULT_FORM_FILE_FIELD_NAME, "multipart/form-data", Boolean.TRUE.booleanValue(), fileName);
        try (OutputStream os = fileItem.getOutputStream();
             ByteArrayInputStream input = new ByteArrayInputStream(fileData);){
            IOUtils.copy((InputStream)input, (OutputStream)os);
        }
        catch (Exception e) {
            log.error("Invalid file: " + e, (Throwable)e);
            throw new CommonException("error.upload.file", new Object[0]);
        }
        CommonsMultipartFile multi = new CommonsMultipartFile((FileItem)fileItem);
        this.fileClient.updateFile(tenantId, key, (MultipartFile)multi);
        return new FileSimpleVO(this.fileClient.getSignedUrl(tenantId, key));
    }

    public FileSimpleVO updateFile(Long tenantId, String key, byte[] fileData) {
        Objects.requireNonNull(tenantId);
        this.fileClient.updateFile(tenantId, key, fileData);
        return new FileSimpleVO(this.fileClient.getSignedUrl(tenantId, key));
    }

    public void deleteFile(Long tenantId, String fileKey) {
        Objects.requireNonNull(tenantId);
        this.fileClient.deleteFileByKey(tenantId, fileKey);
    }

    public String getSignedUrl(Long tenantId, String key) {
        Objects.requireNonNull(tenantId);
        return this.fileClient.getSignedUrl(tenantId, key).getFileTokenUrl();
    }

    public String getSignedUrl(Long tenantId, String bucketName, String url) {
        Objects.requireNonNull(tenantId);
        LOGGER.debug("bucketName : {} and url : {}", (Object)bucketName, (Object)url);
        return this.fileClient.getSignedUrl(tenantId, bucketName, url);
    }

    public FileSimpleVO getFileUrl(Long tenantId, String fileKey) {
        Objects.requireNonNull(tenantId);
        return new FileSimpleVO(this.fileClient.getSignedUrl(tenantId, fileKey));
    }

    public String copyByFileKey(Long tenantId, String fileKey) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(fileKey);
        ResponseEntity<String> responseEntity = this.fileFeign.copyByKey(tenantId, fileKey);
        return FeignUtil.checkFailure(responseEntity);
    }
}

