/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.common.infra.maskant.feign.configuration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.FeignException;
import feign.Response;
import io.choerodon.core.exception.CommonException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;

@Configuration
public class ErrorDecoder
implements feign.codec.ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(ErrorDecoder.class);
    private static final String ERROR_MESSAGE = "message";

    public Exception decode(String methodKey, Response response) {
        if ((response.status() == HttpStatus.BAD_REQUEST.value() || response.status() == HttpStatus.NOT_FOUND.value()) && response.body() != null) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode node = mapper.readTree(response.body().asReader());
                String errorMessage = node.get(ERROR_MESSAGE).textValue();
                return new CommonException(errorMessage, new Object[0]);
            }
            catch (IOException e) {
                log.error("feign request error,message was{}:" + e, (Object)e.getLocalizedMessage());
                return FeignException.errorStatus((String)methodKey, (Response)response);
            }
        }
        return FeignException.errorStatus((String)methodKey, (Response)response);
    }
}

