/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.common.infra.maskant.valueobject;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hzero.boot.file.dto.FileSimpleDTO;

public class FileSimpleVO {
    private String md5;
    private String fileKey;
    private String fileTokenUrl;

    public FileSimpleVO(FileSimpleDTO file) {
        Objects.requireNonNull(file);
        this.fileKey = file.getFileKey();
        this.md5 = file.getMd5();
        this.fileTokenUrl = file.getFileTokenUrl();
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.md5) && StringUtils.isEmpty((CharSequence)this.fileKey) && StringUtils.isEmpty((CharSequence)this.fileTokenUrl);
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public static FileSimpleVOBuilder builder() {
        return new FileSimpleVOBuilder();
    }

    public String getMd5() {
        return this.md5;
    }

    public String getFileKey() {
        return this.fileKey;
    }

    public String getFileTokenUrl() {
        return this.fileTokenUrl;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public void setFileKey(String fileKey) {
        this.fileKey = fileKey;
    }

    public void setFileTokenUrl(String fileTokenUrl) {
        this.fileTokenUrl = fileTokenUrl;
    }

    public FileSimpleVO(String md5, String fileKey, String fileTokenUrl) {
        this.md5 = md5;
        this.fileKey = fileKey;
        this.fileTokenUrl = fileTokenUrl;
    }

    public FileSimpleVO() {
    }

    public String toString() {
        return "FileSimpleVO(md5=" + this.getMd5() + ", fileKey=" + this.getFileKey() + ", fileTokenUrl=" + this.getFileTokenUrl() + ")";
    }

    public static class FileSimpleVOBuilder {
        private String md5;
        private String fileKey;
        private String fileTokenUrl;

        FileSimpleVOBuilder() {
        }

        public FileSimpleVOBuilder md5(String md5) {
            this.md5 = md5;
            return this;
        }

        public FileSimpleVOBuilder fileKey(String fileKey) {
            this.fileKey = fileKey;
            return this;
        }

        public FileSimpleVOBuilder fileTokenUrl(String fileTokenUrl) {
            this.fileTokenUrl = fileTokenUrl;
            return this;
        }

        public FileSimpleVO build() {
            return new FileSimpleVO(this.md5, this.fileKey, this.fileTokenUrl);
        }

        public String toString() {
            return "FileSimpleVO.FileSimpleVOBuilder(md5=" + this.md5 + ", fileKey=" + this.fileKey + ", fileTokenUrl=" + this.fileTokenUrl + ")";
        }
    }
}

