/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.common.repository.impl;

import io.choerodon.core.convertor.ConvertHelper;
import io.choerodon.core.exception.CommonException;
import io.choerodon.core.exception.NotFoundException;
import io.hcbm.common.mappers.OneBaseMapper;
import io.hcbm.common.repository.IOneBaseRepository;
import io.hcbm.common.util.UUIDUtil;
import io.hcbm.common.uuid.IOneDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;

public class OneBaseRepositoryImpl<T extends IOneDomain>
implements IOneBaseRepository<T> {
    private OneBaseMapper<T> _baseMapper;

    protected OneBaseRepositoryImpl(OneBaseMapper<T> baseMapper) {
        this._baseMapper = baseMapper;
    }

    @Override
    @Transactional
    public int deleteByUUID(String uuid) {
        return this._baseMapper.deleteByUUID(UUIDUtil.requiredUUID(uuid));
    }

    @Override
    @Transactional
    public void requiredDeleteByUUID(String uuid) {
        if (this._baseMapper.deleteByUUID(uuid) != 1) {
            throw new NotFoundException("error.delete");
        }
    }

    @Override
    public Optional<T> selectByUUID(String uuid) {
        return Optional.ofNullable(this._baseMapper.selectByUUID(UUIDUtil.requiredUUID(uuid)));
    }

    @Override
    public <R> Optional<R> selectByUUID(String uuid, Class<R> clazz) {
        return this.selectByUUID(uuid).flatMap(t -> Optional.of(clazz).map(rClass -> ConvertHelper.convert((Object)t, (Class)rClass)));
    }

    @Override
    public T requiredSelectByUUID(String uuid) {
        IOneDomain result = (IOneDomain)this._baseMapper.selectByUUID(uuid);
        if (Objects.isNull(result)) {
            throw new NotFoundException("error.select");
        }
        return (T)result;
    }

    @Override
    public <R> R requiredSelectByUUID(String uuid, Class<R> clazz) {
        return (R)ConvertHelper.convert((Object)this.requiredSelectByUUID(uuid), Objects.requireNonNull(clazz));
    }

    @Override
    public <R> R requiredSelectIdByUUID(String uuid, Function<T, R> mapper) {
        IOneDomain result = (IOneDomain)this._baseMapper.selectIdByUUID(uuid);
        if (Objects.isNull(result)) {
            throw new NotFoundException("error.select");
        }
        return mapper.apply(result);
    }

    @Override
    public <R> Optional<R> selectIdByUUID(String uuid, Function<T, R> mapper) {
        return Optional.ofNullable(this._baseMapper.selectIdByUUID(uuid)).map(mapper);
    }

    @Override
    public boolean isExistsWithUUID(String uuid) {
        return this._baseMapper.existsWithUUID(uuid);
    }

    @Override
    @Transactional
    public void requiredUpdateByUUID(T update) {
        this.requiredGetUUID(update);
        if (this._baseMapper.updateByUUID(update) != 1) {
            throw new CommonException("error.update", new Object[0]);
        }
    }

    @Override
    @Transactional
    public T requiredUpdateGetByUUID(T update) {
        String uuid = this.requiredGetUUID(update);
        if (this._baseMapper.updateByUUID(update) != 1) {
            throw new CommonException("error.update", new Object[0]);
        }
        return (T)this.requiredSelectByUUID(uuid);
    }

    @Override
    public <R> R requiredUpdateGetByUUID(T update, Class<R> clazz) {
        T result = this.requiredUpdateGetByUUID(update);
        return (R)ConvertHelper.convert(result, Objects.requireNonNull(clazz));
    }

    @Override
    @Transactional
    public void requiredUpdateSelectiveByUUID(T update) {
        this.requiredGetUUID(update);
        if (this._baseMapper.updateByUUIDSelective(update) != 1) {
            throw new CommonException("error.update", new Object[0]);
        }
    }

    @Override
    @Transactional
    public T requiredUpdateSelectiveGetByUUID(T update) {
        String uuid = this.requiredGetUUID(update);
        if (this._baseMapper.updateByUUIDSelective(update) != 1) {
            throw new CommonException("error.update", new Object[0]);
        }
        return (T)this.requiredSelectByUUID(uuid);
    }

    @Override
    public <R> R requiredUpdateSelectiveGetByUUID(T update, Class<R> clazz) {
        T result = this.requiredUpdateSelectiveGetByUUID(update);
        return (R)ConvertHelper.convert(result, Objects.requireNonNull(clazz));
    }

    @Override
    public List<T> selectByUUIDs(String[] uuidList) {
        return Optional.ofNullable(uuidList).filter(ArrayUtils::isNotEmpty).map(this._baseMapper::selectByUUIDArray).orElseGet(ArrayList::new);
    }

    @Override
    public List<T> selectByUUIDs(Collection<? extends String> uuidList) {
        return Optional.ofNullable(uuidList).filter(CollectionUtils::isNotEmpty).map(this._baseMapper::selectByUUIDList).orElseGet(ArrayList::new);
    }

    protected String requiredGetUUID(T param) {
        String uuid = param.getUuid();
        if (StringUtils.isBlank((CharSequence)uuid)) {
            throw new IllegalArgumentException("uuid is empty");
        }
        return uuid;
    }

    @Override
    public <R> List<R> selectByUUIDs(Collection<? extends String> uuidList, Class<R> clazz) {
        return ConvertHelper.convertList(this.selectByUUIDs(uuidList), Objects.requireNonNull(clazz));
    }

    @Override
    public <R> List<R> selectByUUIDs(String[] uuidList, Class<R> clazz) {
        return ConvertHelper.convertList(this.selectByUUIDs(uuidList), Objects.requireNonNull(clazz));
    }
}

