/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.common.service.impl;

import io.choerodon.core.exception.CommonException;
import io.hcbm.common.infra.maskant.adaptor.ApprovalRuleAdaptor;
import io.hcbm.common.infra.maskant.valueobject.WorkFlowRuleVO;
import io.hcbm.common.service.WorkFlowRuleService;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hzero.boot.platform.lov.adapter.LovAdapter;
import org.hzero.boot.platform.lov.dto.LovValueDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.util.FieldUtils;
import org.springframework.stereotype.Service;

@Service
public class WorkFlowRuleServiceImpl
implements WorkFlowRuleService {
    @Autowired
    private ApprovalRuleAdaptor approvalRuleAdaptor;
    @Autowired
    private LovAdapter lovAdapter;

    @Override
    public WorkFlowRuleVO getWorkFlowModeByObject(String approvedObject, Object object, Long tenantId) {
        String lovCode = "CSYS.APPROVE_VALUE_CON";
        List<LovValueDTO> lovValueDTOs = this.lovAdapter.queryLovValue(lovCode, tenantId);
        HashMap<String, String> approvalMap = new HashMap<String, String>();
        lovValueDTOs = lovValueDTOs.stream().filter(lovValueDTO -> StringUtils.equals((CharSequence)lovValueDTO.getParentValue(), (CharSequence)approvedObject)).collect(Collectors.toList());
        lovValueDTOs.forEach(lovValueDTO -> {
            try {
                approvalMap.put(lovValueDTO.getValue(), (String)FieldUtils.getFieldValue((Object)object, (String)lovValueDTO.getValue()));
            }
            catch (IllegalAccessException e) {
                throw new CommonException("error.maintenance.field", new Object[0]);
            }
        });
        return this.approvalRuleAdaptor.getWorkFlowRule(tenantId, approvedObject, approvalMap);
    }
}

