/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.common.util;

import org.apache.commons.lang3.StringUtils;

public class FileUtil {
    public static String replaceTypeSuffix(String fileName, String newSuffix) {
        if (StringUtils.isEmpty((CharSequence)fileName) || StringUtils.isEmpty((CharSequence)newSuffix) || StringUtils.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)newSuffix)) {
            return fileName;
        }
        String point = ".";
        int index = fileName.lastIndexOf(point);
        String suffixed = newSuffix.startsWith(point) ? newSuffix.toLowerCase() : point + newSuffix.toLowerCase();
        return index == -1 ? fileName + suffixed : fileName.substring(0, index) + suffixed;
    }

    public static String getTypeSuffix(String fileName) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            return "";
        }
        int pointIndex = fileName.lastIndexOf(".");
        if (pointIndex == -1) {
            return "";
        }
        return fileName.substring(pointIndex + 1);
    }

    public static String removeTypeSuffix(String fileName) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            return fileName;
        }
        int pointIndex = fileName.lastIndexOf(".");
        if (pointIndex == -1) {
            return fileName;
        }
        String suffix = fileName.substring(pointIndex);
        int suffixIndex = fileName.indexOf(suffix);
        if (suffixIndex == -1) {
            return fileName.substring(0, pointIndex);
        }
        return fileName.substring(0, suffixIndex);
    }

    public static String copyTypeSuffix(String source, String fileName) {
        String suffix = FileUtil.getTypeSuffix(source);
        return FileUtil.replaceTypeSuffix(fileName, suffix);
    }
}

