/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.sun.corba.se.impl.encoding.OSFCodeSetRegistry;
import io.choerodon.core.exception.CommonException;
import io.hcbm.common.exception.HttpResponseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static final int DEFAULT_CONNECTION_TIME_OUT = 10000;
    private static final int DEFAULT_READ_TIME_OUT = 10000;
    private static final String USER_NAME_FIELD = "username";
    private static final String PASSWORD_FIELD = "password";
    private static final String CLIENT_ID_FIELD = "client_id";
    private static final String CLIENT_SECRET_FIELD = "client_secret";
    private static final String GRANT_TYPE_FIELD = "grant_type";
    private static final String GRANT_TYPE_VALUE = "password";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String AUTHORIZATION_BASIC = "Basic";

    public static JSONObject doOauth2(String url, String userName, String password, String token) throws HttpResponseException {
        Objects.requireNonNull(userName, "\u767b\u5f55\u8d26\u53f7");
        Objects.requireNonNull(password, "\u767b\u5f55\u5bc6\u7801");
        HashMap<String, String> bodyParam = new HashMap<String, String>();
        bodyParam.put(USER_NAME_FIELD, userName);
        bodyParam.put("password", password);
        bodyParam.put(GRANT_TYPE_FIELD, "password");
        if (StringUtils.isBlank((CharSequence)token)) {
            return HttpUtil.sentPostWithForm(url, bodyParam, null);
        }
        HashMap<String, String> headerParam = new HashMap<String, String>();
        headerParam.put(AUTHORIZATION_HEADER, "Basic " + token);
        return HttpUtil.sentPostWithForm(url, bodyParam, headerParam);
    }

    public static JSONObject doOauth2(String url, String username, String password, String clientId, String clientSecret) throws HttpResponseException {
        Objects.requireNonNull(username, "\u767b\u5f55\u8d26\u53f7");
        Objects.requireNonNull(password, "\u767b\u5f55\u5bc6\u7801");
        Objects.requireNonNull(clientId, "\u5ba2\u6237\u7aef\u8d26\u53f7");
        Objects.requireNonNull(clientSecret, "\u5ba2\u6237\u7aef\u5bc6\u7801");
        HashMap<String, String> bodyParam = new HashMap<String, String>(5);
        bodyParam.put(USER_NAME_FIELD, username);
        bodyParam.put("password", password);
        bodyParam.put(CLIENT_ID_FIELD, clientId);
        bodyParam.put(CLIENT_SECRET_FIELD, clientSecret);
        bodyParam.put(GRANT_TYPE_FIELD, "password");
        return HttpUtil.sentPostWithForm(url, bodyParam, null);
    }

    public static JSONObject sentPostWithJsonByAuthorization(String url, Map<String, ?> body, String token) throws HttpResponseException {
        Objects.requireNonNull(token, "Authorization token");
        HashMap<String, String> authHeader = new HashMap<String, String>();
        authHeader.put(AUTHORIZATION_HEADER, token);
        return HttpUtil.sentPostWithJson(url, body, authHeader);
    }

    public static JSONObject sentPostWithJson(String url, Map<String, ?> bodyParam, Map<String, String> headerParam) throws HttpResponseException {
        return HttpUtil.sentPost(url, bodyParam, MediaType.APPLICATION_JSON_UTF8, headerParam);
    }

    public static JSONObject sentPostWithForm(String url, Map<String, ?> bodyParam, Map<String, String> headerParam) throws HttpResponseException {
        return HttpUtil.sentPost(url, bodyParam, MediaType.APPLICATION_FORM_URLENCODED, headerParam);
    }

    public static JSONObject sentPost(String url, Map<String, ?> bodyParam, MediaType contentType, Map<String, String> headerParam) throws HttpResponseException {
        String result = "";
        BufferedReader in = null;
        Integer status = null;
        try {
            URL realUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)realUrl.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            if (Objects.nonNull(headerParam) && !headerParam.isEmpty()) {
                headerParam.forEach(connection::setRequestProperty);
            }
            connection.setDoOutput(true);
            connection.setDoInput(true);
            HttpUtil.processPostContentType(contentType, bodyParam, connection);
            status = connection.getResponseCode();
            try {
                String line;
                in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
                while (StringUtils.isNotEmpty((CharSequence)(line = in.readLine()))) {
                    result = result + line;
                }
            }
            catch (IOException e) {
                String line;
                in = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));
                while (StringUtils.isNotEmpty((CharSequence)(line = in.readLine()))) {
                    result = result + line;
                }
            }
        }
        catch (Exception e) {
            throw new HttpResponseException((Integer)Optional.ofNullable(status).orElse(HttpStatus.INTERNAL_SERVER_ERROR.value()), result, "\u8bf7\u6c42\u5931\u8d25");
        }
        finally {
            try {
                if (Objects.nonNull(in)) {
                    in.close();
                }
            }
            catch (IOException e) {
                log.error("http \u8bf7\u6c42\u5931\u8d25\uff0c\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e);
            }
        }
        if (Objects.isNull(status)) {
            status = HttpStatus.REQUEST_TIMEOUT.value();
        }
        if (status >= 200 && status < 300) {
            return (JSONObject)JSONObject.parse((String)result);
        }
        throw new HttpResponseException(status, result, "POST\u8bf7\u6c42\u5931\u8d25");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processPostContentType(MediaType contentType, Map<String, ?> bodyParam, HttpURLConnection connection) throws IOException {
        Supplier<String> buildParam = null;
        MediaType mediaType = contentType = Objects.isNull(contentType) ? MediaType.APPLICATION_FORM_URLENCODED : contentType;
        if (MediaType.APPLICATION_FORM_URLENCODED.getSubtype().equalsIgnoreCase(contentType.getSubtype())) {
            buildParam = () -> HttpUtil.buildForm(bodyParam);
        } else if (MediaType.APPLICATION_JSON_UTF8.getSubtype().equalsIgnoreCase(contentType.getSubtype())) {
            buildParam = () -> HttpUtil.buildJSON(bodyParam);
        } else {
            contentType = MediaType.APPLICATION_FORM_URLENCODED;
            buildParam = () -> HttpUtil.buildForm(bodyParam);
        }
        PrintWriter out = null;
        connection.setRequestProperty("Content-type", contentType.toString());
        try {
            out = new PrintWriter(new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8));
            out.print(buildParam.get());
            out.flush();
        }
        finally {
            if (Objects.nonNull(out)) {
                out.close();
            }
        }
    }

    private static String buildForm(Map<String, ?> param) {
        if (Objects.isNull(param) || param.isEmpty()) {
            return "";
        }
        return param.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue().toString()).collect(Collectors.joining("&"));
    }

    private static String buildJSON(Map<String, ?> param) {
        if (Objects.isNull(param) || param.isEmpty()) {
            return "";
        }
        return JSON.toJSONString(param);
    }

    public static JSONObject sendGet(String url, Map<String, Object> param, Map<String, String> headerParam) throws HttpResponseException {
        BufferedReader in = null;
        String result = "";
        Integer status = null;
        try {
            String line;
            URL realUrl = new URL(HttpUtil.getUrl(url, param));
            HttpURLConnection connection = (HttpURLConnection)realUrl.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            if (Objects.nonNull(headerParam) && !headerParam.isEmpty()) {
                for (String key2 : headerParam.keySet()) {
                    connection.setRequestProperty(key2, headerParam.get(key2));
                }
            }
            connection.connect();
            status = connection.getResponseCode();
            Map<String, List<String>> map = connection.getHeaderFields();
            map.forEach((key, values) -> log.info(key + ":" + values.toString()));
            try {
                in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
                while ((line = in.readLine()) != null) {
                    result = result + line;
                }
            }
            catch (IOException e) {
                in = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));
                while ((line = in.readLine()) != null) {
                    result = result + line;
                }
            }
        }
        catch (Exception var18) {
            throw new HttpResponseException((Integer)Optional.ofNullable(status).orElse(HttpStatus.INTERNAL_SERVER_ERROR.value()), result, "\u8bf7\u6c42\u5931\u8d25");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                log.error("http \u8bf7\u6c42\u5931\u8d25\uff0c\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e);
            }
        }
        if (Objects.nonNull(status) && status >= 200 && status < 300) {
            return (JSONObject)JSONObject.parse((String)result);
        }
        throw new HttpResponseException(Optional.ofNullable(status).orElse(HttpStatus.REQUEST_TIMEOUT.value()), result, "\u8bf7\u6c42\u5931\u8d25");
    }

    private static String getUrl(String url, Map<String, Object> param) {
        StringBuilder sb = new StringBuilder();
        String equals = "=";
        sb.append(url);
        if (Objects.nonNull(param) && !param.isEmpty()) {
            sb.append("?");
            Object tempValue = null;
            int count = 0;
            for (String key : param.keySet()) {
                tempValue = param.get(key);
                if (tempValue instanceof String && StringUtils.isNotBlank((CharSequence)tempValue.toString())) {
                    sb.append(count == 0 ? "" : "&").append(key).append(equals).append(HttpUtil.encodeUrl(tempValue.toString()));
                    ++count;
                }
                if (!(tempValue instanceof List)) continue;
                List conditions = (List)tempValue;
                for (Object value : conditions) {
                    if (!(value instanceof String) || !StringUtils.isNotBlank((CharSequence)value.toString())) continue;
                    sb.append(count == 0 ? "" : "&").append(key).append(equals).append(HttpUtil.encodeUrl(value.toString()));
                    ++count;
                }
            }
        }
        return sb.toString();
    }

    private static String encodeUrl(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        try {
            return URLEncoder.encode(url, OSFCodeSetRegistry.UTF_8.getName());
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    public static InputStream download(String url) {
        Objects.requireNonNull(url, "url must be not null");
        URL downUrl = null;
        try {
            downUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)downUrl.openConnection();
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            return conn.getInputStream();
        }
        catch (MalformedURLException e) {
            log.info("url:{}", (Object)url);
            e.printStackTrace();
            throw new CommonException("error.url.value", new Object[]{url});
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommonException("error.download.file", new Object[]{url});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] downloadData(String url) {
        Objects.requireNonNull(url, "url must be not null");
        try (InputStream inputStream = HttpUtil.download(url);){
            byte[] byArray = HttpUtil.readInputStream(inputStream);
            return byArray;
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] readInputStream(InputStream inputStream) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

