/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.common.util;

import com.lowagie.text.pdf.PdfReader;
import io.choerodon.core.exception.CommonException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.PDEncryption;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.StandardSecurityHandler;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.springframework.util.FileCopyUtils;

public class PdfReadOnlyUtil {
    public static void fileReadOnly(byte[] pdfData, OutputStream outputStream, String ownerPassword, String userPassword) {
        try {
            PDDocument pdDocument = PDDocument.load((byte[])pdfData);
            AccessPermission permissions = new AccessPermission();
            permissions.setCanModify(false);
            permissions.setReadOnly();
            StandardProtectionPolicy p = new StandardProtectionPolicy(ownerPassword, userPassword, permissions);
            StandardSecurityHandler sh = new StandardSecurityHandler(p);
            sh.prepareDocumentForEncryption(pdDocument);
            PDEncryption encryptionOptions = new PDEncryption();
            encryptionOptions.setSecurityHandler((SecurityHandler)sh);
            pdDocument.setEncryptionDictionary(encryptionOptions);
            pdDocument.save(outputStream);
            pdDocument.close();
        }
        catch (IOException e) {
            throw new CommonException("error.error", new Object[0]);
        }
    }

    public static void fileReadOnly(byte[] pdfData, OutputStream outputStream) {
        PdfReadOnlyUtil.fileReadOnly(pdfData, outputStream, null, null);
    }

    public static void pdfContentToImage(byte[] pdfData, OutputStream outputStream, Integer dpi) throws IOException {
        dpi = (Integer)ObjectUtils.defaultIfNull((Object)dpi, (Object)300);
        List<File> images = PdfReadOnlyUtil.pdf2Image(pdfData, "tempFile", dpi, null);
        try (PDDocument doc = new PDDocument();){
            for (File image : images) {
                PDImageXObject pdImage = PDImageXObject.createFromByteArray((PDDocument)doc, (byte[])FileCopyUtils.copyToByteArray((File)image), (String)image.getName());
                PDPage page = new PDPage(new PDRectangle(0.0f, 0.0f, (float)pdImage.getWidth(), (float)pdImage.getHeight()));
                doc.addPage(page);
                try (PDPageContentStream contents = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, false);){
                    contents.drawImage(pdImage, 0.0f, 0.0f, (float)pdImage.getWidth(), (float)pdImage.getHeight());
                }
                image.delete();
            }
            doc.save(outputStream);
        }
    }

    public static List<File> pdf2Image(byte[] pdfData, String fileName, int dpi, Integer page) throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        PdfReader reader = new PdfReader(pdfData);
        int pages = reader.getNumberOfPages();
        if (page != null && page >= 0 && page < pages) {
            PdfReadOnlyUtil.getImageResult(pdfData, result, fileName, page, dpi);
        } else {
            for (int i = 0; i < pages; ++i) {
                PdfReadOnlyUtil.getImageResult(pdfData, result, fileName, i, dpi);
            }
        }
        return result;
    }

    private static void getImageResult(byte[] fileContents, List<File> result, String fileName, Integer page, int dpi) throws IOException {
        PDDocument pdDocument = PDDocument.load((byte[])fileContents);
        PDFRenderer renderer = new PDFRenderer(pdDocument);
        StringBuilder imgFilePath = null;
        imgFilePath = new StringBuilder();
        imgFilePath.append(fileName);
        imgFilePath.append("_");
        imgFilePath.append(page + 1);
        File dstFile = File.createTempFile(imgFilePath.toString(), ".jpg");
        BufferedImage image = renderer.renderImageWithDPI(page.intValue(), (float)dpi);
        ImageIO.write((RenderedImage)image, "jpg", dstFile);
        result.add(dstFile);
    }
}

