/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.common.util;

import com.lowagie.text.pdf.PdfReader;
import io.choerodon.core.exception.CommonException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PdfUtil {
    public static void getPagesOfPdf(InputStream sourcePdf, OutputStream outputStream, int page) {
        ArrayList<Integer> pages = new ArrayList<Integer>();
        pages.add(page);
        PdfUtil.getPagesOfPdf(sourcePdf, outputStream, pages);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getTotalPageOfPdf(InputStream sourcePdf) {
        Objects.requireNonNull(sourcePdf);
        try (InputStream is = sourcePdf;){
            PdfReader reader = new PdfReader(is);
            int n = reader.getNumberOfPages();
            return n;
        }
        catch (IOException e) {
            throw new CommonException("", (Throwable)e);
        }
    }

    public static void getPagesOfPdf(InputStream sourcePdf, OutputStream outputStream, List<Integer> pages) {
        Objects.requireNonNull(sourcePdf);
        Objects.requireNonNull(outputStream);
        assert (CollectionUtils.isNotEmpty(pages));
        try (InputStream is = sourcePdf;){
            PDDocument pdDocument = PDDocument.load((InputStream)is);
            int pageTotal = pdDocument.getNumberOfPages();
            boolean result = pages.stream().anyMatch(page -> page < 1 || page > pageTotal);
            if (result) {
                throw new CommonException("error.invalid.page", new Object[0]);
            }
            PDDocument outDocument = new PDDocument();
            for (Integer page2 : pages) {
                outDocument.addPage(pdDocument.getPage(page2 - 1));
            }
            outDocument.save(outputStream);
            pdDocument.close();
            outDocument.close();
        }
        catch (IOException e) {
            throw new CommonException("", (Throwable)e);
        }
    }
}

