/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.common.util;

import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class UUIDUtil {
    private static final Pattern uidPattern = Pattern.compile("[a-z0-9]{32}");

    public static String generateUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static boolean isUUID(String uuid) {
        if (StringUtils.isBlank((CharSequence)uuid)) {
            return false;
        }
        return uuid.length() == 32 && uidPattern.matcher(uuid).find();
    }

    public static String requiredUUID(String uuid) {
        if (UUIDUtil.isUUID(uuid)) {
            return uuid;
        }
        throw new IllegalArgumentException("error uuid");
    }
}

