/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.common.uuid;

import io.choerodon.mybatis.domain.AuditDomain;
import io.hcbm.common.util.UUIDUtil;
import io.hcbm.common.uuid.IOneDomain;
import io.hcbm.common.valid.group.Update;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.lang3.StringUtils;

public class OneAuditDomain
extends AuditDomain
implements IOneDomain {
    @NotEmpty(groups={Update.class})
    @GeneratedValue(generator="UUID")
    @ApiModelProperty(hidden=true)
    @Column(updatable=false)
    private String uuid;

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public void uuidVisit(IOneDomain domain) {
        if (Objects.isNull(this.uuid)) {
            this.uuid = domain.getUuid();
        } else if (!this.uuid.equals(domain.getUuid())) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void updateUuid(String uuid) {
        if (StringUtils.isEmpty((CharSequence)uuid) || StringUtils.equals((CharSequence)uuid, (CharSequence)this.uuid)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.uuid)) {
            throw new UnsupportedOperationException("UUID cannot be overwritten");
        }
        this.uuid = UUIDUtil.requiredUUID(uuid);
    }

    @Override
    public void clearUuid() {
        this.uuid = null;
    }
}

