/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.onlyoffice;

import io.choerodon.core.exception.CommonException;
import io.hcbm.common.infra.maskant.adaptor.FileAdaptor;
import io.hcbm.common.util.HttpUtil;
import io.hcbm.onlyoffice.service.OneOfficeService;
import io.hcbm.onlyoffice.valueobject.CustomizationParam;
import io.hcbm.onlyoffice.valueobject.PermissionVO;
import io.hcbm.onlyoffice.valueobject.SaveCallbackParam;
import io.hcbm.onlyoffice.valueobject.SaveParam;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneOfficeClient {
    private static final Logger log = LoggerFactory.getLogger(OneOfficeClient.class);
    private FileAdaptor fileAdaptor;
    private OneOfficeService oneOfficeService;
    private static final Pattern fileNamePattern = Pattern.compile("[0-9]/.+(@|%40)(.+)");

    public OneOfficeClient(FileAdaptor fileAdaptor, OneOfficeService oneOfficeService) {
        this.fileAdaptor = fileAdaptor;
        this.oneOfficeService = oneOfficeService;
    }

    public String generateHtml(Long tenantId, String textFileKey, PermissionVO permission, CustomizationParam customization, String callBackEndUrl) {
        String htmlText;
        String fileUrl = this.fileAdaptor.getSignedUrl(tenantId, textFileKey);
        String fileName = this.getFileNameFromKey(textFileKey);
        try {
            htmlText = this.oneOfficeService.getGenerateHtml(textFileKey, fileUrl, fileName, permission, customization, "onlyOffice", callBackEndUrl);
        }
        catch (Exception e) {
            log.error("onlyOffice generateHtml method occur IOException,message was:" + e.getLocalizedMessage());
            throw new CommonException("error.onlyOffice.generateHtml", new Object[0]);
        }
        return htmlText;
    }

    public String generateHtml(Long tenantId, String textFileKey, PermissionVO permission, String callBackEndUrl) {
        return this.generateHtml(tenantId, textFileKey, permission, null, callBackEndUrl);
    }

    public void updateTextInfoByOnlyOffice(Long tenantId, SaveCallbackParam saveCallbackParam, String fileKey) {
        log.debug("only office update text saveCallbackParam : {} and fileKey : {}", (Object)saveCallbackParam, (Object)fileKey);
        this.fileAdaptor.updateFile(tenantId, fileKey, HttpUtil.downloadData(saveCallbackParam.getUrl()));
    }

    private String getFileNameFromKey(String filekey) {
        Matcher matcher = fileNamePattern.matcher(filekey);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return filekey;
    }

    public void triggerSaveDoc(SaveParam saveParam) {
        this.oneOfficeService.saveDoc(saveParam);
    }
}

