/*
 * Decompiled with CFR 0.152.
 */
package io.hcbm.trx.app.service.impl;

import io.hcbm.trx.app.service.TrxTaskBackService;
import io.hcbm.trx.app.service.TrxTaskInstanceService;
import io.hcbm.trx.domain.entity.TrxTaskInstance;
import io.hcbm.trx.domain.repository.TrxTaskInstanceRepository;
import io.hcbm.trx.domain.vo.TrxCommonResponse;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class TrxTaskInstanceServiceImpl
implements TrxTaskInstanceService {
    private static final Logger log = LoggerFactory.getLogger(TrxTaskInstanceServiceImpl.class);
    private TrxTaskInstanceRepository repository;

    public TrxTaskInstanceServiceImpl(TrxTaskInstanceRepository repository) {
        this.repository = repository;
    }

    @Override
    public TrxTaskInstance insertWithUuid(TrxTaskInstance trxTaskInstance) {
        return this.repository.insertWithUuid(trxTaskInstance);
    }

    @Override
    public TrxTaskInstance updateWithUuid(TrxTaskInstance trxTaskInstance) {
        return this.repository.updateWithUuid(trxTaskInstance);
    }

    @Override
    public void deleteWithUuid(TrxTaskInstance trxTaskInstance) {
        this.repository.deleteWithUuid(trxTaskInstance);
    }

    @Override
    public TrxTaskInstance selectWithUuid(TrxTaskInstance trxTaskInstance) {
        return this.repository.selectWithUuid(trxTaskInstance);
    }

    @Override
    public <T> void startTaskInstance(final TrxTaskInstance trxTaskInstance, final TrxTaskBackService<T> callback) {
        Objects.requireNonNull(trxTaskInstance);
        Objects.requireNonNull(trxTaskInstance.getTaskCode());
        trxTaskInstance.setStatusCode("PENDIG");
        this.insertWithUuid(trxTaskInstance);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                TrxCommonResponse response = new TrxCommonResponse();
                try {
                    response = callback.process((Object)trxTaskInstance);
                }
                catch (Exception e) {
                    log.error("task instance process error", (Throwable)e);
                    response.setStatus(false);
                    response.setCode("error.exception_in_process");
                    response.setMessage(e.toString());
                }
                if (Objects.isNull(response)) {
                    response = TrxCommonResponse.success();
                }
                if (response.getStatus().booleanValue()) {
                    TrxTaskInstanceServiceImpl.this.repository.deleteWithUuid(trxTaskInstance);
                } else {
                    trxTaskInstance.setStatusCode("ERROR");
                    trxTaskInstance.setErrorMessage(response.getMessage());
                    TrxTaskInstanceServiceImpl.this.repository.updateWithUuid(trxTaskInstance);
                }
            }
        });
    }
}

