/*
 * Decompiled with CFR 0.152.
 */
package org.srm.amkt.client.infra.account;

import com.alibaba.fastjson.JSON;
import java.security.Key;
import java.security.interfaces.RSAPublicKey;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.concurrent.ConcurrentHashMap;
import org.hzero.core.util.EncryptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.srm.amkt.client.api.dto.ClientSecretDTO;
import org.srm.amkt.client.api.dto.InterfaceResponse;
import org.srm.amkt.client.domain.entity.CertifiedAccount;
import org.srm.amkt.client.infra.constant.Constants;
import org.srm.amkt.client.infra.properties.AmktClientProperties;
import org.srm.amkt.client.infra.util.BaseUtil;
import org.srm.amkt.client.service.ClientInterfaceService;

@Component
public class GeneralAccountUtil {
    private static Logger logger = LoggerFactory.getLogger(GeneralAccountUtil.class);
    @Autowired
    private ClientInterfaceService serviceTypeService;
    @Autowired
    private AmktClientProperties clientProperties;
    private static final ConcurrentHashMap<String, CertifiedAccount> CERTIFIED_ACCOUNT = new ConcurrentHashMap();

    public static CertifiedAccount get(String accountKey) {
        return CERTIFIED_ACCOUNT.get(accountKey);
    }

    public static void set(String accountKey, CertifiedAccount certifiedAccount) {
        CERTIFIED_ACCOUNT.put(accountKey, certifiedAccount);
    }

    public static void remove(String clientId) {
        CERTIFIED_ACCOUNT.remove(clientId);
    }

    public CertifiedAccount checkAccount(String crmTenant, String clientCode, String url) {
        String accountKey = clientCode + crmTenant;
        CertifiedAccount certifiedAccount = new CertifiedAccount();
        ClientSecretDTO clientSecretDTO = new ClientSecretDTO();
        clientSecretDTO.setClient(clientCode);
        clientSecretDTO.setCrmTenant(crmTenant);
        logger.info("query client account >>> clientCode={},crmTenant={}", (Object)clientCode, (Object)crmTenant);
        InterfaceResponse response = this.serviceTypeService.queryEncryptedTenantClient(clientSecretDTO);
        if (!BaseUtil.checkInterfaceResponse(response)) {
            this.setCertifiedAccountInfo(certifiedAccount, this.clientProperties.getOauth().getClientId(), this.clientProperties.getOauth().getClientSecret(), url, Constants.Client.ORGANIZATION_ID, null, null);
            accountKey = clientCode + Constants.Client.ORGANIZATION_ID;
            GeneralAccountUtil.set(accountKey, certifiedAccount);
        } else {
            RSAPublicKey key = EncryptionUtils.RSA.getPublicKey((String)this.clientProperties.getClient().getPublicKey());
            String decryptText = EncryptionUtils.RSA.decrypt((String)response.getData().toString(), (Key)key);
            ClientSecretDTO resultSecretDTO = (ClientSecretDTO)JSON.parseObject((String)decryptText, ClientSecretDTO.class);
            this.setCertifiedAccountInfo(certifiedAccount, resultSecretDTO.getName(), resultSecretDTO.getSecret(), url, resultSecretDTO.getTenantId(), resultSecretDTO.getLoginName(), resultSecretDTO.getUserPassword());
            GeneralAccountUtil.set(accountKey, certifiedAccount);
        }
        return certifiedAccount;
    }

    private void setCertifiedAccountInfo(CertifiedAccount certifiedAccount, String apiKey, String apiSecret, String url, Long organizationId, String username, String password) {
        String requestUrl = MessageFormat.format(url, organizationId);
        certifiedAccount.setRequestUrl(requestUrl);
        certifiedAccount.setApiKey(apiKey);
        certifiedAccount.setApiSecret(apiSecret);
        certifiedAccount.setTenantId(organizationId);
        certifiedAccount.setUsername(username);
        if (!StringUtils.isEmpty((Object)password)) {
            certifiedAccount.setPassword(Base64.getEncoder().encodeToString(password.getBytes()));
        }
    }
}

