/*
 * Decompiled with CFR 0.152.
 */
package org.srm.amkt.client.infra.oauth;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.choerodon.core.exception.CommonException;
import io.choerodon.core.oauth.DetailsHelper;
import java.util.Map;
import org.hzero.core.base.BaseConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.srm.amkt.client.domain.entity.CertifiedAccount;
import org.srm.amkt.client.infra.oauth.GeneralTokenUtil;
import org.srm.amkt.client.infra.oauth.handler.ClientRequestEroorHandler;
import org.srm.amkt.client.infra.oauth.vo.AccessToken;
import org.srm.amkt.client.infra.properties.AmktClientProperties;

@Component
public class ClientRestTemplateUtil {
    private static final Logger logger = LoggerFactory.getLogger(ClientRestTemplateUtil.class);
    @Autowired
    private GeneralTokenUtil generalTokenUtil;
    @Autowired
    private AmktClientProperties clientProperties;

    public <T> ResponseEntity<T> exchange(String url, String clientId, String clientSecret, HttpMethod method, ParameterizedTypeReference<T> responseType, Map<String, Object> uriVariables, Object postData) {
        logger.info(String.format("\u8bf7\u6c42 >>> %s ...", url));
        CertifiedAccount certifiedAccount = new CertifiedAccount();
        certifiedAccount.setApiKey(clientId);
        certifiedAccount.setApiSecret(clientSecret);
        AccessToken accessToken = this.generalTokenUtil.generalToken(certifiedAccount, null, "client_credentials");
        if (accessToken == null) {
            throw new CommonException("\u83b7\u53d6token\u5931\u8d25", new Object[0]);
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Authorization", "Bearer " + accessToken.getAccess_token());
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new ClientRequestEroorHandler());
        Long useTenant = DetailsHelper.getUserDetails().getOrganizationId();
        Long tenantId = DetailsHelper.getUserDetails().getTenantId();
        if (useTenant == null) {
            useTenant = BaseConstants.DEFAULT_TENANT_ID;
        }
        if (tenantId == null) {
            tenantId = BaseConstants.DEFAULT_TENANT_ID;
        }
        ResponseEntity responseEntity = null;
        try {
            if (HttpMethod.GET.equals((Object)method)) {
                HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
                responseEntity = restTemplate.exchange(this.clientProperties.getGateway().getUrl() + "/" + "amkt" + url, method, requestEntity, responseType, uriVariables);
            } else if (HttpMethod.POST.equals((Object)method) || HttpMethod.PUT.equals((Object)method) || HttpMethod.DELETE.equals((Object)method)) {
                if (postData == null) {
                    throw new CommonException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
                }
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)postData));
                jsonObject.put("useTenant", (Object)useTenant);
                jsonObject.put("tenant", (Object)tenantId);
                postData = JSON.toJavaObject((JSON)jsonObject, Object.class);
                HttpEntity requestEntity = new HttpEntity(postData, (MultiValueMap)httpHeaders);
                responseEntity = restTemplate.exchange(this.clientProperties.getGateway().getUrl() + "/" + "amkt" + url, method, requestEntity, responseType, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new CommonException(e.getMessage(), new Object[0]);
        }
        if (!HttpStatus.OK.equals((Object)responseEntity.getStatusCode())) {
            GeneralTokenUtil.remove("client_credentials" + clientId);
            GeneralTokenUtil.remove("password" + clientId);
            throw new CommonException("\u8bf7\u6c42\u5e73\u53f0\u63a5\u53e3\u5931\u8d25", new Object[0]);
        }
        logger.info(String.format("\u7ed3\u679c >>> %s ...", responseEntity));
        return responseEntity;
    }

    public <T> AccessToken exchangeForToken(CertifiedAccount certifiedAccount, AccessToken accessToken, HttpMethod method, ParameterizedTypeReference<T> responseType, Map<String, Object> uriVariables) {
        logger.info(String.format("\u8bf7\u6c42 >>> %s ...", "/iam/hzero/v1/users/self"));
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Authorization", "Bearer " + accessToken.getAccess_token());
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new ClientRequestEroorHandler());
        ResponseEntity responseEntity = null;
        try {
            HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
            responseEntity = restTemplate.exchange(this.clientProperties.getGateway().getUrl() + "/" + "/iam/hzero/v1/users/self", method, requestEntity, responseType, uriVariables);
            if (!HttpStatus.OK.equals((Object)responseEntity.getStatusCode())) {
                GeneralTokenUtil.remove("password" + certifiedAccount.getApiKey());
                accessToken = this.generalTokenUtil.generalToken(certifiedAccount, null, "client_credentials");
            }
        }
        catch (Exception e) {
            GeneralTokenUtil.remove("password" + certifiedAccount.getApiKey());
            accessToken = this.generalTokenUtil.generalToken(certifiedAccount, null, "client_credentials");
        }
        logger.info(String.format("\u7ed3\u679c >>> %s ...", responseEntity));
        return accessToken;
    }
}

