/*
 * Decompiled with CFR 0.152.
 */
package org.srm.amkt.client.infra.oauth;

import io.choerodon.core.exception.CommonException;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hzero.core.util.EncryptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.srm.amkt.client.domain.entity.CertifiedAccount;
import org.srm.amkt.client.infra.oauth.vo.AccessToken;
import org.srm.amkt.client.infra.oauth.vo.OAuthClient;
import org.srm.amkt.client.infra.properties.AmktClientProperties;

@Component
public class GeneralTokenUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneralTokenUtil.class);
    private String PASSWORD_TOKENPATH = "/oauth/oauth/token";
    private String CLIENT_TOKENPATH = "/oauth/oauth/token?grant_type={grant_type}&client_id={client_id}&client_secret={client_secret}&username={username}&password={password}";
    private String REFRESH_TOKENPATH = "/oauth/oauth/token?grant_type={grant_scope}&refresh_token={refresh_token}&client_id={client_id}&client_secret={client_secret}";
    private String tokenPath = null;
    @Autowired
    private AmktClientProperties clientProperties;
    private static final ConcurrentHashMap<String, AccessToken> ACCESS_TOKEN = new ConcurrentHashMap();

    public static AccessToken get(String clientId) {
        return ACCESS_TOKEN.get(clientId);
    }

    public static void set(String clientId, AccessToken accessToken) {
        ACCESS_TOKEN.put(clientId, accessToken);
    }

    public static void remove(String clientId) {
        ACCESS_TOKEN.remove(clientId);
    }

    public AccessToken generalToken(CertifiedAccount certifiedAccount, String scope, String grantType) {
        RestTemplate restTemplate = new RestTemplate();
        OAuthClient client = new OAuthClient(grantType, certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), certifiedAccount.getUsername(), certifiedAccount.getPassword(), scope);
        if ("password".equals(grantType)) {
            client.setPassword(EncryptionUtils.RSA.encrypt((String)new String(Base64.getDecoder().decode(certifiedAccount.getPassword())), (String)"MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCZ60UZ1QkkkAM+joJkF2YKDGhoDYDbYUj4p1Y5SvCTpSudHGghmv+/H3kcxV6dUmaa7qrhpUpb6Vud5VqC5JlnsgCtpWC4hZGRVtBYLjmzoNkPfU/ZKYtSaE3lnQQTN0wZVl1fdysAWtLiCalfDMdWF2WwqqvydzKtzB2Up8X4kwIDAQAB"));
            this.tokenPath = this.clientProperties.getGateway().getUrl() + this.PASSWORD_TOKENPATH;
        } else {
            this.tokenPath = this.clientProperties.getGateway().getUrl() + this.CLIENT_TOKENPATH;
        }
        AccessToken existsAccessToken = GeneralTokenUtil.get(grantType + client.getClientId());
        if (existsAccessToken != null && existsAccessToken.getExpiresAt().after(new Date())) {
            return existsAccessToken;
        }
        HashMap<String, Object> clientMap = client.buildClientMap();
        if (existsAccessToken != null && existsAccessToken.getExpiresAt().before(new Date())) {
            GeneralTokenUtil.remove(grantType + certifiedAccount.getApiKey());
        }
        try {
            LOGGER.debug("tokenPath: {}", (Object)this.tokenPath);
            LOGGER.debug("clientMap: {}", clientMap);
            ResponseEntity responseEntity = null;
            if ("password".equals(grantType)) {
                LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
                for (Map.Entry entry : clientMap.entrySet()) {
                    requestBody.add(entry.getKey(), entry.getValue());
                }
                HttpEntity requestEntity = new HttpEntity((Object)requestBody);
                responseEntity = restTemplate.postForEntity(this.tokenPath, (Object)requestEntity, AccessToken.class, new Object[0]);
            } else {
                responseEntity = restTemplate.postForEntity(this.tokenPath, null, AccessToken.class, clientMap);
            }
            if (HttpStatus.OK.equals((Object)responseEntity.getStatusCode())) {
                AccessToken accessToken = (AccessToken)responseEntity.getBody();
                if (accessToken != null) {
                    LOGGER.info(">>>>> Obtain {} access_token success. tokenPath={}, statusCode={}\uff0cresult={}", new Object[]{certifiedAccount.getApiKey(), this.tokenPath, responseEntity.getStatusCode(), accessToken});
                }
                GeneralTokenUtil.set(grantType + certifiedAccount.getApiKey(), accessToken);
                return accessToken;
            }
            throw new CommonException("\u83b7\u53d6token\u5931\u8d25", new Object[0]);
        }
        catch (Exception e) {
            GeneralTokenUtil.remove(grantType + certifiedAccount.getApiKey());
            throw new CommonException(e.getMessage(), new Object[0]);
        }
    }
}

