/*
 * Decompiled with CFR 0.152.
 */
package org.srm.amkt.client.infra.util;

import com.timevale.esign.sdk.tech.bean.result.Result;
import com.timevale.esign.sdk.tech.v3.client.ServiceClient;
import com.timevale.esign.sdk.tech.v3.client.ServiceClientManager;
import com.timevale.tech.sdk.bean.HttpConnectionConfig;
import com.timevale.tech.sdk.bean.ProjectConfig;
import com.timevale.tech.sdk.bean.SignatureConfig;
import com.timevale.tech.sdk.constants.AlgorithmType;
import io.choerodon.core.exception.CommonException;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.srm.amkt.client.infra.constant.Constants;

@Component
public class InitSignUtil {
    private static Logger logger = LoggerFactory.getLogger(InitSignUtil.class);

    public ServiceClient getServiceClient(String api, String projectId, String projectSecret) {
        if (ObjectUtils.isEmpty((Object)projectId)) {
            return null;
        }
        ServiceClient serviceClient = ServiceClientManager.get((String)projectId);
        if (serviceClient != null) {
            return serviceClient;
        }
        InitSignUtil.doRegistryClient(api, projectId, projectSecret);
        return ServiceClientManager.get((String)projectId);
    }

    private static void doRegistryClient(String api, String projectId, String projectSecret) throws CommonException {
        Result result;
        ProjectConfig proCfg = new ProjectConfig();
        proCfg.setProjectId(projectId);
        proCfg.setProjectSecret(projectSecret);
        proCfg.setItsmApiUrl(api);
        HttpConnectionConfig httpConCfg = new HttpConnectionConfig();
        httpConCfg.setHttpType(Constants.Sign.HTTP_TYPE);
        httpConCfg.setRetry(Integer.valueOf(5));
        SignatureConfig signCfg = new SignatureConfig();
        signCfg.setAlgorithm(Constants.Sign.ALGORITHM_TYPE);
        if (AlgorithmType.RSA == Constants.Sign.ALGORITHM_TYPE) {
            signCfg.setEsignPublicKey(Constants.Sign.ESIGN_PUBLIC_KEY);
            signCfg.setPrivateKey(Constants.Sign.PRIVATE_KEY);
        }
        if (0 != (result = ServiceClientManager.registClient((ProjectConfig)proCfg, (HttpConnectionConfig)httpConCfg, (SignatureConfig)signCfg)).getErrCode()) {
            String exMsg = MessageFormat.format("\u6ce8\u518c[{0}]\u7684\u5ba2\u6237\u7aef\u5931\u8d25: errCode = {1},msg = {2}", projectId, String.valueOf(result.getErrCode()), result.getMsg());
            throw new CommonException(exMsg, new Object[0]);
        }
        logger.info("\u6ce8\u518c[{}]\u7684\u5ba2\u6237\u7aef\u6210\u529f: errCode = {},msg = {}", new Object[]{projectSecret, result.getErrCode(), result.getMsg()});
    }
}

