/*
 * Decompiled with CFR 0.152.
 */
package org.srm.amkt.client.service.impl;

import com.alibaba.fastjson.JSON;
import io.choerodon.core.exception.CommonException;
import java.security.interfaces.RSAPublicKey;
import java.text.MessageFormat;
import java.util.HashMap;
import org.hzero.core.util.EncryptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.srm.amkt.client.api.dto.ClientSecretDTO;
import org.srm.amkt.client.api.dto.InterfaceResponse;
import org.srm.amkt.client.api.dto.OpenServiceFlagDTO;
import org.srm.amkt.client.api.dto.TokenUrlDTO;
import org.srm.amkt.client.api.dto.sign.AccountDTO;
import org.srm.amkt.client.domain.entity.CertifiedAccount;
import org.srm.amkt.client.domain.entity.EsignAccount;
import org.srm.amkt.client.infra.account.GeneralAccountUtil;
import org.srm.amkt.client.infra.constant.Constants;
import org.srm.amkt.client.infra.oauth.ClientRestTemplateUtil;
import org.srm.amkt.client.infra.oauth.GeneralTokenUtil;
import org.srm.amkt.client.infra.oauth.vo.AccessToken;
import org.srm.amkt.client.infra.properties.AmktClientProperties;
import org.srm.amkt.client.infra.util.BaseUtil;
import org.srm.amkt.client.service.ClientInterfaceService;

@Service
public class ClientInterfaceServiceImpl
implements ClientInterfaceService {
    @Autowired
    private ClientRestTemplateUtil clientRestTemplateUtil;
    @Autowired
    private GeneralTokenUtil generalTokenUtil;
    @Autowired
    private GeneralAccountUtil generalAccountUtil;
    @Autowired
    private AmktClientProperties clientProperties;

    @Override
    public InterfaceResponse queryEncryptedTenantClient(ClientSecretDTO request) {
        String url = MessageFormat.format("/v1/{0}/query/secret-client", Constants.Client.ORGANIZATION_ID);
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(url, this.clientProperties.getOauth().getClientId(), this.clientProperties.getOauth().getClientSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, request);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public TokenUrlDTO spliceToken2Url(Long organizationId, String url) {
        TokenUrlDTO tokenUrlDTO = new TokenUrlDTO();
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/enterprise/credit/authentication");
        if (StringUtils.isEmpty((Object)certifiedAccount.getUsername()) || StringUtils.isEmpty((Object)certifiedAccount.getPassword())) {
            url = url + "#" + "access_token" + "=" + "null";
            tokenUrlDTO.setUrl(url);
            tokenUrlDTO.setTenantId(Constants.Client.ORGANIZATION_ID);
            tokenUrlDTO.setClientCode(this.clientProperties.getClient().getCode());
            return tokenUrlDTO;
        }
        AccessToken accessToken = this.generalTokenUtil.generalToken(certifiedAccount, "default", "password");
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        accessToken = this.clientRestTemplateUtil.exchangeForToken(certifiedAccount, accessToken, HttpMethod.GET, new ParameterizedTypeReference<Object>(){}, uriVariables);
        url = url + "#" + "access_token" + "=" + accessToken.getAccess_token();
        tokenUrlDTO.setUrl(url);
        tokenUrlDTO.setTenantId(certifiedAccount.getTenantId());
        tokenUrlDTO.setClientCode(this.clientProperties.getClient().getCode());
        tokenUrlDTO.setExpiresAt(accessToken.getExpiresAt());
        return tokenUrlDTO;
    }

    @Override
    public InterfaceResponse isOpenService(Long organizationId, OpenServiceFlagDTO openServiceFlagDTO) {
        openServiceFlagDTO.setClient(this.clientProperties.getClient().getCode());
        openServiceFlagDTO.setTenant(organizationId);
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/application/open-service-flag");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, openServiceFlagDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public EsignAccount queryEsignAccount(String organizationId) {
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(organizationId, this.clientProperties.getClient().getCode(), "/v1/accounts/{0}/accounts/e-sign");
        AccountDTO accountDTO = new AccountDTO();
        accountDTO.setTenantId(certifiedAccount.getTenantId());
        accountDTO.setClient(this.clientProperties.getClient().getCode());
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, accountDTO);
        InterfaceResponse interfaceResponse = (InterfaceResponse)response.getBody();
        if (!BaseUtil.checkInterfaceResponse(interfaceResponse)) {
            throw new CommonException(interfaceResponse.getCode() + ":" + interfaceResponse.getMsg(), new Object[0]);
        }
        RSAPublicKey key = EncryptionUtils.RSA.getPublicKey((String)this.clientProperties.getClient().getPublicKey());
        String decryptText = BaseUtil.decrypt(interfaceResponse.getData().toString(), key);
        return (EsignAccount)JSON.parseObject((String)decryptText, EsignAccount.class);
    }
}

