/*
 * Decompiled with CFR 0.152.
 */
package org.srm.amkt.client.service.impl;

import io.choerodon.core.exception.CommonException;
import io.choerodon.core.oauth.DetailsHelper;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.srm.amkt.client.api.dto.CompanyDTO;
import org.srm.amkt.client.api.dto.GroupDTO;
import org.srm.amkt.client.api.dto.InterfaceResponse;
import org.srm.amkt.client.api.dto.MonitorDTO;
import org.srm.amkt.client.api.dto.RiskSacnDTO;
import org.srm.amkt.client.domain.entity.CertifiedAccount;
import org.srm.amkt.client.infra.account.GeneralAccountUtil;
import org.srm.amkt.client.infra.oauth.ClientRestTemplateUtil;
import org.srm.amkt.client.infra.properties.AmktClientProperties;
import org.srm.amkt.client.infra.util.BaseUtil;
import org.srm.amkt.client.service.EnterpriseCreditService;

@Service
public class EnterpriseCreditServiceImpl
implements EnterpriseCreditService {
    @Autowired
    private ClientRestTemplateUtil clientRestTemplateUtil;
    @Autowired
    private GeneralAccountUtil generalAccountUtil;
    @Autowired
    private AmktClientProperties clientProperties;

    @Override
    public InterfaceResponse checkEnterpriseInfo(Long organizationId, String moduleCode, String companyName, String unifiedSocialCode) {
        if (StringUtils.isEmpty((Object)moduleCode)) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("companyName", companyName);
        map.put("unifiedSocialCode", unifiedSocialCode);
        map.put("moduleCode", moduleCode);
        map.put("client", this.clientProperties.getClient().getCode());
        map.put("tenant", DetailsHelper.getUserDetails().getTenantId());
        map.put("useTenant", DetailsHelper.getUserDetails().getOrganizationId());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/enterprise/credit/authentication");
        String urlAppend = BaseUtil.transferMap2UrlParam(map);
        String url = certifiedAccount.getRequestUrl() + urlAppend;
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(url, certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.GET, new ParameterizedTypeReference<InterfaceResponse>(){}, map, null);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse enterpriseRelationship(Long organizationId, CompanyDTO companyDTO) {
        if (StringUtils.isEmpty((Object)companyDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        companyDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/enterprise/credit/relationship");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, companyDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse addGroup(Long organizationId, GroupDTO groupDTO) {
        if (StringUtils.isEmpty((Object)groupDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        groupDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/enterprise/credit/group");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, groupDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse updateGroup(Long organizationId, GroupDTO groupDTO) {
        if (StringUtils.isEmpty((Object)groupDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        groupDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/enterprise/credit/group");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.PUT, new ParameterizedTypeReference<InterfaceResponse>(){}, null, groupDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse deleteGroup(Long organizationId, GroupDTO groupDTO) {
        if (StringUtils.isEmpty((Object)groupDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        groupDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/enterprise/credit/group");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.DELETE, new ParameterizedTypeReference<InterfaceResponse>(){}, null, groupDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse addMonitor(Long organizationId, MonitorDTO monitorDTO) {
        if (StringUtils.isEmpty((Object)monitorDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        monitorDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/enterprise/credit/monitor");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, monitorDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse deleteMonitor(Long organizationId, MonitorDTO monitorDTO) {
        if (StringUtils.isEmpty((Object)monitorDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        monitorDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/enterprise/credit/monitor-cancel");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, monitorDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse getEventDic(Long organizationId, String moduleCode) {
        if (StringUtils.isEmpty((Object)moduleCode)) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("moduleCode", moduleCode);
        map.put("client", this.clientProperties.getClient().getCode());
        map.put("useTenant", DetailsHelper.getUserDetails().getOrganizationId());
        map.put("tenant", DetailsHelper.getUserDetails().getTenantId());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/enterprise/credit/event-dic");
        String urlAppend = BaseUtil.transferMap2UrlParam(map);
        String url = certifiedAccount.getRequestUrl() + urlAppend;
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(url, certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.GET, new ParameterizedTypeReference<InterfaceResponse>(){}, map, null);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse updateMonitor(Long organizationId, MonitorDTO monitorDTO) {
        if (StringUtils.isEmpty((Object)monitorDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        monitorDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/enterprise/credit/monitor");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.PUT, new ParameterizedTypeReference<InterfaceResponse>(){}, null, monitorDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse queryRiskScan(Long organizationId, String moduleCode, String enterpriseName) {
        if (StringUtils.isEmpty((Object)moduleCode)) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        RiskSacnDTO riskSacnDTO = new RiskSacnDTO();
        riskSacnDTO.setEnterpriseName(enterpriseName);
        riskSacnDTO.setClient(this.clientProperties.getClient().getCode());
        riskSacnDTO.setModuleCode(moduleCode);
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/enterprise/credit/risk-scan");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, riskSacnDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse queryGroupMonitor(Long organizationId, String moduleCode, String groupId) {
        if (StringUtils.isEmpty((Object)moduleCode)) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("moduleCode", moduleCode);
        map.put("client", this.clientProperties.getClient().getCode());
        map.put("groupId", groupId);
        map.put("useTenant", DetailsHelper.getUserDetails().getOrganizationId());
        map.put("tenant", DetailsHelper.getUserDetails().getTenantId());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/enterprise/credit/group-monitor");
        String urlAppend = BaseUtil.transferMap2UrlParam(map);
        String url = certifiedAccount.getRequestUrl() + urlAppend;
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(url, certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.GET, new ParameterizedTypeReference<InterfaceResponse>(){}, map, null);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse enterpriseBusiness(Long organizationId, String companyName, String moduleCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("moduleCode", moduleCode);
        map.put("client", this.clientProperties.getClient().getCode());
        map.put("companyName", companyName);
        map.put("useTenant", DetailsHelper.getUserDetails().getOrganizationId());
        map.put("tenant", DetailsHelper.getUserDetails().getTenantId());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/enterprise/credit/enterprise-business");
        String urlAppend = BaseUtil.transferMap2UrlParam(map);
        String url = certifiedAccount.getRequestUrl() + urlAppend;
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(url, certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.GET, new ParameterizedTypeReference<InterfaceResponse>(){}, map, null);
        return (InterfaceResponse)response.getBody();
    }
}

