/*
 * Decompiled with CFR 0.152.
 */
package org.srm.amkt.client.service.impl;

import io.choerodon.core.exception.CommonException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.srm.amkt.client.api.dto.InterfaceResponse;
import org.srm.amkt.client.api.dto.ocr.InvoiceOcrDto;
import org.srm.amkt.client.domain.entity.CertifiedAccount;
import org.srm.amkt.client.infra.account.GeneralAccountUtil;
import org.srm.amkt.client.infra.oauth.ClientRestTemplateUtil;
import org.srm.amkt.client.infra.properties.AmktClientProperties;
import org.srm.amkt.client.service.EnterpriseInvoiceOcrService;

@Service
public class EnterpriseInvoiceOcrServiceImpl
implements EnterpriseInvoiceOcrService {
    @Autowired
    private ClientRestTemplateUtil clientRestTemplateUtil;
    @Autowired
    private GeneralAccountUtil generalAccountUtil;
    @Autowired
    private AmktClientProperties clientProperties;

    @Override
    public InterfaceResponse invoiceOcr(Long organizationId, InvoiceOcrDto invoiceOcrDto) {
        if (StringUtils.isEmpty((Object)invoiceOcrDto.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        invoiceOcrDto.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/ocr/invoiceOcr");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, invoiceOcrDto);
        return (InterfaceResponse)response.getBody();
    }
}

