/*
 * Decompiled with CFR 0.152.
 */
package org.srm.amkt.client.service.impl;

import io.choerodon.core.exception.CommonException;
import io.choerodon.core.oauth.DetailsHelper;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.srm.amkt.client.api.dto.InterfaceResponse;
import org.srm.amkt.client.api.dto.invoice.CollectDTO;
import org.srm.amkt.client.api.dto.invoice.FormatfileBuildDTO;
import org.srm.amkt.client.api.dto.invoice.InvoiceGoodsCodeAddDTO;
import org.srm.amkt.client.api.dto.invoice.InvoiceGoodsCodeDeleteDTO;
import org.srm.amkt.client.api.dto.invoice.InvoiceInvalidDTO;
import org.srm.amkt.client.api.dto.invoice.InvoiceOpenDTO;
import org.srm.amkt.client.api.dto.invoice.InvoicePrintDTO;
import org.srm.amkt.client.api.dto.invoice.InvoiceQueryDTO;
import org.srm.amkt.client.api.dto.invoice.InvoiceTaxDiskGoodsCodeDTO;
import org.srm.amkt.client.api.dto.invoice.MonitorRequestDTO;
import org.srm.amkt.client.api.dto.invoice.RegisterDTO;
import org.srm.amkt.client.domain.entity.CertifiedAccount;
import org.srm.amkt.client.infra.account.GeneralAccountUtil;
import org.srm.amkt.client.infra.oauth.ClientRestTemplateUtil;
import org.srm.amkt.client.infra.properties.AmktClientProperties;
import org.srm.amkt.client.infra.util.BaseUtil;
import org.srm.amkt.client.service.EnterpriseInvoiceService;

@Service
public class EnterpriseInvoiceServiceImpl
implements EnterpriseInvoiceService {
    @Autowired
    private ClientRestTemplateUtil clientRestTemplateUtil;
    @Autowired
    private GeneralAccountUtil generalAccountUtil;
    @Autowired
    private AmktClientProperties clientProperties;

    @Override
    public InterfaceResponse invoiceTaxDiskGoodsCode(Long organizationId, InvoiceTaxDiskGoodsCodeDTO invoiceTaxDiskGoodsCodeDTO) {
        if (StringUtils.isEmpty((Object)invoiceTaxDiskGoodsCodeDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sellerTaxNo", invoiceTaxDiskGoodsCodeDTO.getSellerTaxNo());
        map.put("taxDiskNo", invoiceTaxDiskGoodsCodeDTO.getTaxDiskNo());
        map.put("moduleCode", invoiceTaxDiskGoodsCodeDTO.getModuleCode());
        map.put("client", this.clientProperties.getClient().getCode());
        map.put("useTenant", DetailsHelper.getUserDetails().getOrganizationId());
        map.put("tenant", DetailsHelper.getUserDetails().getTenantId());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/invoice/query-goods");
        String urlAppend = BaseUtil.transferMap2UrlParam(map);
        String url = certifiedAccount.getRequestUrl() + urlAppend;
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(url, certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.GET, new ParameterizedTypeReference<InterfaceResponse>(){}, map, null);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse goodsCodeAdd(Long organizationId, InvoiceGoodsCodeAddDTO invoiceGoodsCodeAddDTO) {
        if (StringUtils.isEmpty((Object)invoiceGoodsCodeAddDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        invoiceGoodsCodeAddDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/invoice/add-goods");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, invoiceGoodsCodeAddDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse goodsCodeDelete(Long organizationId, InvoiceGoodsCodeDeleteDTO invoiceGoodsCodeDeleteDTO) {
        if (StringUtils.isEmpty((Object)invoiceGoodsCodeDeleteDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        invoiceGoodsCodeDeleteDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/invoice/delete-goods");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, invoiceGoodsCodeDeleteDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse invoiceOpen(Long organizationId, InvoiceOpenDTO invoiceOpenDTO) {
        if (StringUtils.isEmpty((Object)invoiceOpenDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        invoiceOpenDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/invoice/invoice-open");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, invoiceOpenDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse invoiceQuery(Long organizationId, InvoiceQueryDTO invoiceQueryDTO) {
        if (StringUtils.isEmpty((Object)invoiceQueryDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sellerTaxNo", invoiceQueryDTO.getSellerTaxNo());
        map.put("invoiceQueryType", invoiceQueryDTO.getInvoiceQueryType());
        map.put("serialNo", invoiceQueryDTO.getSerialNo());
        map.put("invoiceCode", invoiceQueryDTO.getInvoiceCode());
        map.put("invoiceNo", invoiceQueryDTO.getInvoiceNo());
        map.put("invoiceTerminalCode", invoiceQueryDTO.getInvoiceTerminalCode());
        map.put("invoiceStartDate", invoiceQueryDTO.getInvoiceStartDate());
        map.put("invoiceEndDate", invoiceQueryDTO.getInvoiceEndDate());
        map.put("buyerTaxNo", invoiceQueryDTO.getBuyerTaxNo());
        map.put("buyerName", invoiceQueryDTO.getBuyerName());
        map.put("organizationCode", invoiceQueryDTO.getOrganizationCode());
        map.put("trackNumber", invoiceQueryDTO.getTrackNumber());
        map.put("reqSerialNumber", invoiceQueryDTO.getReqSerialNumber());
        map.put("moduleCode", invoiceQueryDTO.getModuleCode());
        map.put("client", this.clientProperties.getClient().getCode());
        map.put("useTenant", DetailsHelper.getUserDetails().getOrganizationId());
        map.put("tenant", DetailsHelper.getUserDetails().getTenantId());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/invoice/invoice-query");
        String urlAppend = BaseUtil.transferMap2UrlParam(map);
        String url = certifiedAccount.getRequestUrl() + urlAppend;
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(url, certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.GET, new ParameterizedTypeReference<InterfaceResponse>(){}, map, null);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse invoiceInvalid(Long organizationId, InvoiceInvalidDTO invoiceInvalidDTO) {
        if (StringUtils.isEmpty((Object)invoiceInvalidDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        invoiceInvalidDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/invoice/invoice-invalid");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, invoiceInvalidDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse invoicePrint(Long organizationId, InvoicePrintDTO invoicePrintDTO) {
        if (StringUtils.isEmpty((Object)invoicePrintDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        invoicePrintDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/invoice/invoice-print");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, invoicePrintDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse formatFileBuild(Long organizationId, FormatfileBuildDTO formatfileBuildDTO) {
        if (StringUtils.isEmpty((Object)formatfileBuildDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        formatfileBuildDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/invoice/formatfile-build");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, formatfileBuildDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse inputCollect(Long organizationId, CollectDTO collectDTO) {
        if (StringUtils.isEmpty((Object)collectDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        collectDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/invoice/invoice-collect");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, collectDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse register(Long organizationId, RegisterDTO registerDTO) {
        if (StringUtils.isEmpty((Object)registerDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        registerDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/invoice/register");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, registerDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse taxMonitorQuery(Long organizationId, MonitorRequestDTO monitorRequestDTO) {
        if (StringUtils.isEmpty((Object)monitorRequestDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        monitorRequestDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/invoice/monitor-query");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, monitorRequestDTO);
        return (InterfaceResponse)response.getBody();
    }
}

