/*
 * Decompiled with CFR 0.152.
 */
package org.srm.amkt.client.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.srm.amkt.client.api.dto.InterfaceResponse;
import org.srm.amkt.client.api.dto.SrdMessageDTO;
import org.srm.amkt.client.api.dto.bo.BaseBO;
import org.srm.amkt.client.domain.entity.CertifiedAccount;
import org.srm.amkt.client.infra.account.GeneralAccountUtil;
import org.srm.amkt.client.infra.constant.Constants;
import org.srm.amkt.client.infra.oauth.ClientRestTemplateUtil;
import org.srm.amkt.client.infra.properties.AmktClientProperties;
import org.srm.amkt.client.service.EnterpriseMessageService;

@Service
public class EnterpriseMessageServiceImpl
implements EnterpriseMessageService {
    @Autowired
    private ClientRestTemplateUtil clientRestTemplateUtil;
    @Autowired
    private AmktClientProperties clientProperties;
    @Autowired
    private GeneralAccountUtil generalAccountUtil;

    @Override
    public InterfaceResponse queryMessage(BaseBO baseBO) {
        baseBO.setClient(this.clientProperties.getClient().getCode());
        baseBO.setModuleCode("SSLM");
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(Constants.Client.ORGANIZATION_ID), this.clientProperties.getClient().getCode(), "/v1/{0}/enterprise/credit/message");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, baseBO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse deleteMessage(SrdMessageDTO srdMessageDTO) {
        srdMessageDTO.setClient(this.clientProperties.getClient().getCode());
        srdMessageDTO.setModuleCode("SSLM");
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(Constants.Client.ORGANIZATION_ID), this.clientProperties.getClient().getCode(), "/v1/{0}/enterprise/credit/message");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.PUT, new ParameterizedTypeReference<InterfaceResponse>(){}, null, srdMessageDTO);
        return (InterfaceResponse)response.getBody();
    }
}

