/*
 * Decompiled with CFR 0.152.
 */
package org.srm.amkt.client.service.impl;

import com.timevale.esign.sdk.tech.bean.AbstractSignPdfBean;
import com.timevale.esign.sdk.tech.bean.result.FileDigestSignResult;
import com.timevale.esign.sdk.tech.bean.result.Result;
import com.timevale.esign.sdk.tech.impl.constants.SignType;
import com.timevale.esign.sdk.tech.service.UserSignService;
import com.timevale.esign.sdk.tech.v3.client.ServiceClient;
import io.choerodon.core.exception.CommonException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.srm.amkt.client.api.dto.InterfaceResponse;
import org.srm.amkt.client.api.dto.sign.SignAccountDTO;
import org.srm.amkt.client.api.dto.sign.SignDepositCertificateDataDTO;
import org.srm.amkt.client.api.dto.sign.SignDetailsDTO;
import org.srm.amkt.client.api.dto.sign.SignEnterpriseInfoDTO;
import org.srm.amkt.client.api.dto.sign.SignEvidencePointDTO;
import org.srm.amkt.client.api.dto.sign.SignMobileCodeDTO;
import org.srm.amkt.client.api.dto.sign.SignPersonalCodeValidDTO;
import org.srm.amkt.client.api.dto.sign.SignPersonalRealNameDTO;
import org.srm.amkt.client.api.dto.sign.SignProofLinkDTO;
import org.srm.amkt.client.api.dto.sign.SignRemitBankInfoDTO;
import org.srm.amkt.client.api.dto.sign.SignRemitCompanyDTO;
import org.srm.amkt.client.api.dto.sign.SignRemitPayAuthDTO;
import org.srm.amkt.client.api.dto.sign.SignRemitPayDTO;
import org.srm.amkt.client.api.dto.sign.SignSceneRelateDTO;
import org.srm.amkt.client.api.dto.sign.SignStreamSignDTO;
import org.srm.amkt.client.api.dto.sign.SignStreamVerifyDTO;
import org.srm.amkt.client.api.dto.sign.SignSummaryEvidencePointDTO;
import org.srm.amkt.client.api.dto.sign.SignUpdateAccountDTO;
import org.srm.amkt.client.api.dto.sign.SignVoucherDTO;
import org.srm.amkt.client.domain.entity.CertifiedAccount;
import org.srm.amkt.client.domain.entity.EsignAccount;
import org.srm.amkt.client.infra.account.GeneralAccountUtil;
import org.srm.amkt.client.infra.constant.Constants;
import org.srm.amkt.client.infra.oauth.ClientRestTemplateUtil;
import org.srm.amkt.client.infra.properties.AmktClientProperties;
import org.srm.amkt.client.infra.util.InitSignUtil;
import org.srm.amkt.client.service.ClientInterfaceService;
import org.srm.amkt.client.service.EnterpriseSignService;

@Service
public class EnterpriseSignServiceImpl
implements EnterpriseSignService {
    @Autowired
    private ClientRestTemplateUtil clientRestTemplateUtil;
    @Autowired
    private GeneralAccountUtil generalAccountUtil;
    @Autowired
    private ClientInterfaceService interfaceService;
    @Autowired
    private InitSignUtil initSignUtil;
    @Autowired
    private AmktClientProperties clientProperties;

    @Override
    public InterfaceResponse accountRegister(Long organizationId, SignAccountDTO signAccountDTO) {
        if (StringUtils.isEmpty((Object)signAccountDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        signAccountDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/sign/account-register");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, signAccountDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse deleteAccount(Long organizationId, SignUpdateAccountDTO signUpdateAccountDTO) {
        if (StringUtils.isEmpty((Object)signUpdateAccountDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        signUpdateAccountDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/sign/delete-account");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, signUpdateAccountDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse updateAccount(Long organizationId, SignUpdateAccountDTO signUpdateAccountDTO) {
        if (StringUtils.isEmpty((Object)signUpdateAccountDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        signUpdateAccountDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/sign/update-account");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, signUpdateAccountDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse getAccountInfoByIdNo(Long organizationId, SignAccountDTO signAccountDTO) {
        if (StringUtils.isEmpty((Object)signAccountDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        signAccountDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/sign/account-info-by-id-no");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, signAccountDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse fileStreamSignPdf(Long organizationId, SignStreamSignDTO signStreamSignDTO) {
        SignType signType;
        EsignAccount esignAccount = this.interfaceService.queryEsignAccount(String.valueOf(organizationId));
        ServiceClient serviceClient = this.initSignUtil.getServiceClient(esignAccount.getUrl(), esignAccount.getProjectId(), esignAccount.getProjectSecret());
        UserSignService userSignService = serviceClient.userSignService();
        SignType signType2 = signType = ObjectUtils.isEmpty((Object)signStreamSignDTO.getSignType()) ? null : SignType.valueOf((String)signStreamSignDTO.getSignType());
        if (ObjectUtils.isEmpty((Object)signStreamSignDTO.getCode())) {
            FileDigestSignResult fileDigestSignResult = userSignService.localSignPDF(signStreamSignDTO.getAccountId(), signStreamSignDTO.getSealData(), (AbstractSignPdfBean)signStreamSignDTO.getStream(), signStreamSignDTO.getSignPos(), signType);
            return this.getInterfaceResponse((Result)fileDigestSignResult);
        }
        if (!ObjectUtils.isEmpty((Object)signStreamSignDTO.getCode())) {
            if (ObjectUtils.isEmpty((Object)signStreamSignDTO.getMobile())) {
                FileDigestSignResult fileDigestSignResult = userSignService.localSafeSignPDF(signStreamSignDTO.getAccountId(), signStreamSignDTO.getSealData(), (AbstractSignPdfBean)signStreamSignDTO.getStream(), signStreamSignDTO.getSignPos(), signType, signStreamSignDTO.getCode());
                return this.getInterfaceResponse((Result)fileDigestSignResult);
            }
            FileDigestSignResult fileDigestSignResult = userSignService.localSafeSignPDF3rd(signStreamSignDTO.getAccountId(), signStreamSignDTO.getSealData(), (AbstractSignPdfBean)signStreamSignDTO.getStream(), signStreamSignDTO.getSignPos(), signType, signStreamSignDTO.getMobile(), signStreamSignDTO.getCode());
            return this.getInterfaceResponse((Result)fileDigestSignResult);
        }
        return new InterfaceResponse(false, "10001", "\u53c2\u6570\u9519\u8bef\u6216\u4e3a\u7a7a");
    }

    private InterfaceResponse getInterfaceResponse(Result result) {
        if (Constants.Sign.E_SIGN_SUCESS.intValue() != result.getErrCode()) {
            return new InterfaceResponse<Result>(false, "30001", result.getMsg(), result);
        }
        return new InterfaceResponse<Result>(true, "00000", null, result);
    }

    @Override
    public InterfaceResponse sendSignMobileCode(Long organizationId, SignMobileCodeDTO signMobileCodeDTO) {
        if (StringUtils.isEmpty((Object)signMobileCodeDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        signMobileCodeDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/sign/send-sign-mobile-code");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, signMobileCodeDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse fileSteamVerifyPdf(Long organizationId, SignStreamVerifyDTO signStreamVerifyDTO) {
        if (StringUtils.isEmpty((Object)signStreamVerifyDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        signStreamVerifyDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/sign/file-steam-verify-pdf");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, signStreamVerifyDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse getSignDetail(Long organizationId, SignDetailsDTO signDetailsDTO) {
        if (StringUtils.isEmpty((Object)signDetailsDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        signDetailsDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/sign/sign-detail");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, signDetailsDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse enterpriseCheck(Long organizationId, SignRemitCompanyDTO signRemitCompanyDTO) {
        if (StringUtils.isEmpty((Object)signRemitCompanyDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        signRemitCompanyDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/sign/enterprise-check");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, signRemitCompanyDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse remitPay(Long organizationId, SignRemitPayDTO signRemitPayDTO) {
        if (StringUtils.isEmpty((Object)signRemitPayDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        signRemitPayDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/sign/remit-pay");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, signRemitPayDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse payAuth(Long organizationId, SignRemitPayAuthDTO signRemitPayAuthDTO) {
        if (StringUtils.isEmpty((Object)signRemitPayAuthDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        signRemitPayAuthDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/sign/pay-auth");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, signRemitPayAuthDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse bankBranchInformation(Long organizationId, SignRemitBankInfoDTO signRemitBankInfoDTO) {
        if (StringUtils.isEmpty((Object)signRemitBankInfoDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        signRemitBankInfoDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/sign/bank-branch-information");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, signRemitBankInfoDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse enterpriseRealNameAuth(Long organizationId, SignEnterpriseInfoDTO signEnterpriseInfoDTO) {
        if (StringUtils.isEmpty((Object)signEnterpriseInfoDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        signEnterpriseInfoDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/sign/enterprise-real-name-auth");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, signEnterpriseInfoDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse personalRealNameAuth(Long organizationId, SignPersonalRealNameDTO signPersonalRealNameDTO) {
        if (StringUtils.isEmpty((Object)signPersonalRealNameDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        signPersonalRealNameDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/sign/personal-real-name-auth");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, signPersonalRealNameDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse personalCodeValid(Long organizationId, SignPersonalCodeValidDTO signPersonalRealNameDTO) {
        if (StringUtils.isEmpty((Object)signPersonalRealNameDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        signPersonalRealNameDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/sign/personal-code-valid");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, signPersonalRealNameDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse existenceDataDictionary(Long organizationId, SignDepositCertificateDataDTO signDepositCertificateDataDTO) {
        if (StringUtils.isEmpty((Object)signDepositCertificateDataDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        signDepositCertificateDataDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/sign/existence-data-dictionary");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, signDepositCertificateDataDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse createEvidenceChain(Long organizationId, SignVoucherDTO signVoucherDTO) {
        if (StringUtils.isEmpty((Object)signVoucherDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        signVoucherDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/sign/create-evidence-chain");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, signVoucherDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse createSummaryEvidencePoint(Long organizationId, SignSummaryEvidencePointDTO signSummaryEvidencePointDTO) {
        if (StringUtils.isEmpty((Object)signSummaryEvidencePointDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        signSummaryEvidencePointDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/sign/create-summary-evidence-point");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, signSummaryEvidencePointDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse adjunctiveEvidencePoint(Long organizationId, SignEvidencePointDTO signEvidencePointDTO) {
        if (StringUtils.isEmpty((Object)signEvidencePointDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        signEvidencePointDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/sign/adjunctive-evidence-point");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, signEvidencePointDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse associatedUser(Long organizationId, SignSceneRelateDTO signSceneRelateDTO) {
        if (StringUtils.isEmpty((Object)signSceneRelateDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        signSceneRelateDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/sign/associated-user");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, signSceneRelateDTO);
        return (InterfaceResponse)response.getBody();
    }

    @Override
    public InterfaceResponse getProofLink(Long organizationId, SignProofLinkDTO signProofLinkDTO) {
        if (StringUtils.isEmpty((Object)signProofLinkDTO.getModuleCode())) {
            throw new CommonException("\u6a21\u5757\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        signProofLinkDTO.setClient(this.clientProperties.getClient().getCode());
        CertifiedAccount certifiedAccount = this.generalAccountUtil.checkAccount(String.valueOf(organizationId), this.clientProperties.getClient().getCode(), "/v1/{0}/sign/get-proof-link");
        ResponseEntity<InterfaceResponse> response = this.clientRestTemplateUtil.exchange(certifiedAccount.getRequestUrl(), certifiedAccount.getApiKey(), certifiedAccount.getApiSecret(), HttpMethod.POST, new ParameterizedTypeReference<InterfaceResponse>(){}, null, signProofLinkDTO);
        return (InterfaceResponse)response.getBody();
    }
}

