/*
 * Decompiled with CFR 0.152.
 */
package org.srm.amkt.client.service.impl;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;
import org.srm.amkt.client.api.dto.InterfaceResponse;
import org.srm.amkt.client.api.dto.SrdMessageDTO;
import org.srm.amkt.client.api.dto.bo.BaseBO;
import org.srm.amkt.client.domain.entity.EnterpriseEvent;
import org.srm.amkt.client.domain.entity.SrdMessage;
import org.srm.amkt.client.infra.feign.ClientEnterpriseEventService;
import org.srm.amkt.client.infra.properties.AmktClientProperties;
import org.srm.amkt.client.infra.util.BaseUtil;
import org.srm.amkt.client.service.EnterpriseMessageService;
import org.srm.amkt.client.service.MessageScheduleTaskService;

@Service
public class MessageScheduleTaskServiceImpl
implements MessageScheduleTaskService {
    @Autowired
    private ThreadPoolTaskScheduler threadPoolTaskScheduler;
    @Autowired
    private EnterpriseMessageService enterpriseMessageService;
    @Autowired
    private ClientEnterpriseEventService enterpriseEventService;
    @Autowired
    private AmktClientProperties clientProperties;
    private static final ConcurrentHashMap<String, ScheduledFuture> SCHEDULE_TASK_MAP = new ConcurrentHashMap();
    private static final Logger logger = LoggerFactory.getLogger(MessageScheduleTaskServiceImpl.class);

    public static void removeScheduleTaskFuture(String taskName) {
        SCHEDULE_TASK_MAP.remove(taskName);
    }

    @Override
    public void startScheduleTask(String taskName) {
        if (this.clientProperties.getSchedule().isEnabled()) {
            logger.info(">>\u5b9a\u65f6\u4efb\u52a1\u5f00\u542f");
            ScheduledFuture scheduledFuture = this.threadPoolTaskScheduler.schedule(() -> {
                SrdMessage srdMessage;
                BaseBO baseBO = new BaseBO();
                baseBO.setClient("HZERO");
                InterfaceResponse interfaceResponse = this.enterpriseMessageService.queryMessage(baseBO);
                if (BaseUtil.checkInterfaceResponse(interfaceResponse) && (srdMessage = (SrdMessage)((Object)((Object)JSON.parseObject((String)JSON.toJSONString(interfaceResponse.getData()), SrdMessage.class)))) != null) {
                    List riskEventList = JSON.parseArray((String)srdMessage.getEventdata(), EnterpriseEvent.class);
                    ResponseEntity responseEntity = this.enterpriseEventService.createEnterpriseMonitorMessage(Long.valueOf(srdMessage.getCrmTenant()), riskEventList);
                    if (HttpStatus.NO_CONTENT.equals((Object)responseEntity.getStatusCode()) || HttpStatus.OK.equals((Object)responseEntity.getStatusCode())) {
                        SrdMessageDTO srdMessageDTO = new SrdMessageDTO();
                        srdMessageDTO.setMessageId(srdMessage.getMessageId());
                        srdMessageDTO.setObjectVersionNumber(srdMessage.getObjectVersionNumber());
                        this.enterpriseMessageService.deleteMessage(srdMessageDTO);
                    }
                }
            }, triggerContext -> {
                CronTrigger trigger = new CronTrigger(this.clientProperties.getSchedule().getCron());
                Date nextExecDate = trigger.nextExecutionTime(triggerContext);
                return nextExecDate;
            });
            SCHEDULE_TASK_MAP.put(taskName, scheduledFuture);
        }
    }

    @Override
    public void stopScheduleTask(String taskName) {
        ScheduledFuture scheduledFuture = SCHEDULE_TASK_MAP.get(taskName);
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
            MessageScheduleTaskServiceImpl.removeScheduleTaskFuture(taskName);
        }
    }
}

